package com.jz.jar.business.wrapper;

import java.util.List;

import com.jz.jooq.franchise.tables.pojos.ParentInfo;

public class UserWrapper {
	private UserWrapper() {
	}

	// 基本信息
	private String uid;
	private String phone;
	private String name;
	private String avatar;

	// 登录相关
	private String token;
	private Boolean isRegister;

	// 学员信息
	private List<StudentWrapper> students;

	// 关注、粉丝数
	private Integer fansCnt;
	private Integer followCnt;
	// 是否关注
	private Boolean isFollow;

	private Integer tomatoCoin;
	private Integer coin;

	private String imUid;
	private String sig;

	public static UserWrapper of(ParentInfo parentInfo) {
		return new UserWrapper().setUid(parentInfo.getPuid()).setName(parentInfo.getName());
	}

	public String getUid() {
		return uid;
	}

	public UserWrapper setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getToken() {
		return token;
	}

	public UserWrapper setToken(String token) {
		this.token = token;
		return this;
	}

	public Boolean getIsRegister() {
		return isRegister;
	}

	public UserWrapper setIsRegister(Boolean isRegister) {
		this.isRegister = isRegister;
		return this;
	}

	public List<StudentWrapper> getStudents() {
		return students;
	}

	public UserWrapper setStudents(List<StudentWrapper> students) {
		this.students = students;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public UserWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getName() {
		return name;
	}

	public UserWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getAvatar() {
		return avatar;
	}

	public UserWrapper setAvatar(String avatar) {
		this.avatar = avatar;
		return this;
	}

	public Integer getFansCnt() {
		return fansCnt;
	}

	public UserWrapper setFansCnt(Integer fansCnt) {
		this.fansCnt = fansCnt;
		return this;
	}

	public Integer getFollowCnt() {
		return followCnt;
	}

	public UserWrapper setFollowCnt(Integer followCnt) {
		this.followCnt = followCnt;
		return this;
	}

	public Boolean getIsFollow() {
		return isFollow;
	}

	public UserWrapper setIsFollow(Boolean isFollow) {
		this.isFollow = isFollow;
		return this;
	}

	public Integer getTomatoCoin() {
		return tomatoCoin;
	}

	public UserWrapper setTomatoCoin(Integer tomatoCoin) {
		this.tomatoCoin = tomatoCoin;
		return this;
	}

	public Integer getCoin() {
		return coin;
	}

	public UserWrapper setCoin(Integer coin) {
		this.coin = coin;
		return this;
	}

	public String getSig() {
		return sig;
	}

	public UserWrapper setSig(String sig) {
		this.sig = sig;
		return this;
	}

	public String getImUid() {
		return imUid;
	}

	public UserWrapper setImUid(String imUid) {
		this.imUid = imUid;
		return this;
	}

}