package com.jz.jar.business.wrapper;

import com.jz.jooq.live.tables.pojos.LiveInfo;

public class LiveSimpleWrapper {

	private String lid;
	private String name;
	private Integer type;
	private String mainSpeaker;
	private Long planStartTime;
	private Long planEndTime;
	private Long actStartTime;
	private Long actEndTime;
	private Integer status;
	private String roomId;
	private Integer watchNum;

	private Boolean isFree;
	private String pid;
	private Integer learnStatus; // 学习状态
	private Boolean isAudition;
	private Integer seq; // 集数

	public static LiveSimpleWrapper of(LiveInfo l, int type) {
		return new LiveSimpleWrapper().setLid(l.getLid()).setName(l.getName()).setType(l.getType())
				.setMainSpeaker(l.getMainSpeaker()).setPlanStartTime(l.getPlanStartTime())
				.setPlanEndTime(l.getPlanEndTime()).setActStartTime(l.getActStartTime())
				.setActEndTime(l.getActEndTime()).setStatus(l.getStatus()).setRoomId(l.getRoomId())
				.setWatchNum(l.getWatchNum()).setIsFree(type == 0); // 0免费1付费
	}

	public String getLid() {
		return lid;
	}

	public LiveSimpleWrapper setLid(String lid) {
		this.lid = lid;
		return this;
	}

	public String getName() {
		return name;
	}

	public LiveSimpleWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getMainSpeaker() {
		return mainSpeaker;
	}

	public LiveSimpleWrapper setMainSpeaker(String mainSpeaker) {
		this.mainSpeaker = mainSpeaker;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public LiveSimpleWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getRoomId() {
		return roomId;
	}

	public LiveSimpleWrapper setRoomId(String roomId) {
		this.roomId = roomId;
		return this;
	}

	public Integer getWatchNum() {
		return watchNum;
	}

	public LiveSimpleWrapper setWatchNum(Integer watchNum) {
		this.watchNum = watchNum;
		return this;
	}

	public Long getPlanStartTime() {
		return planStartTime;
	}

	public LiveSimpleWrapper setPlanStartTime(Long planStartTime) {
		this.planStartTime = planStartTime;
		return this;
	}

	public Long getPlanEndTime() {
		return planEndTime;
	}

	public LiveSimpleWrapper setPlanEndTime(Long planEndTime) {
		this.planEndTime = planEndTime;
		return this;
	}

	public Long getActStartTime() {
		return actStartTime;
	}

	public LiveSimpleWrapper setActStartTime(Long actStartTime) {
		this.actStartTime = actStartTime;
		return this;
	}

	public Long getActEndTime() {
		return actEndTime;
	}

	public LiveSimpleWrapper setActEndTime(Long actEndTime) {
		this.actEndTime = actEndTime;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public LiveSimpleWrapper setType(Integer type) {
		this.type = type;
		return this;
	}

	public Integer getLearnStatus() {
		return learnStatus;
	}

	public LiveSimpleWrapper setLearnStatus(Integer learnStatus) {
		this.learnStatus = learnStatus;
		return this;
	}

	public Boolean getIsFree() {
		return isFree;
	}

	public LiveSimpleWrapper setIsFree(Boolean isFree) {
		this.isFree = isFree;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public LiveSimpleWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public Boolean getIsAudition() {
		return isAudition;
	}

	public LiveSimpleWrapper setIsAudition(Boolean isAudition) {
		this.isAudition = isAudition;
		return this;
	}

	public Integer getSeq() {
		return seq;
	}

	public void setSeq(Integer seq) {
		this.seq = seq;
	}

}
