package com.jz.jar.business.wrapper;

import com.jz.jooq.media.tables.pojos.TomatoImageText;

public class WImageText {
	private WImageText() {
	}

	// 图文信息
	private String iid;
	private String name;
	private String content;
	private String pic;
	private Long lastUpdated;

	private Boolean isCollect;

	// 观看收藏数量
	private Integer watchCnt;
	private Integer collectCnt;

	// 专辑信息
	private String pid;
	private PlaylistWrapper playlist;

	public static WImageText of(TomatoImageText imageText, String pid) {
		return new WImageText().setIid(imageText.getId()).setName(imageText.getName())
				.setContent(imageText.getContent()).setLastUpdated(imageText.getLastUpdated())
				.setWatchCnt(imageText.getWatchCnt()).setPid(pid);
	}

	public String getIid() {
		return iid;
	}

	public WImageText setIid(String iid) {
		this.iid = iid;
		return this;
	}

	public String getName() {
		return name;
	}

	public WImageText setName(String name) {
		this.name = name;
		return this;
	}

	public String getContent() {
		return content;
	}

	public WImageText setContent(String content) {
		this.content = content;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public WImageText setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public Long getLastUpdated() {
		return lastUpdated;
	}

	public WImageText setLastUpdated(Long lastUpdated) {
		this.lastUpdated = lastUpdated;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public WImageText setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	public Integer getWatchCnt() {
		return watchCnt;
	}

	public WImageText setWatchCnt(Integer watchCnt) {
		this.watchCnt = watchCnt;
		return this;
	}

	public Integer getCollectCnt() {
		return collectCnt;
	}

	public WImageText setCollectCnt(Integer collectCnt) {
		this.collectCnt = collectCnt;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public WImageText setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public PlaylistWrapper getPlaylist() {
		return playlist;
	}

	public WImageText setPlaylist(PlaylistWrapper playlist) {
		this.playlist = playlist;
		return this;
	}

}
