package com.jz.jar.business.wrapper;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.card.CpItemCard;
import com.jz.jooq.media.tables.pojos.AiPackCamp;
import com.jz.jooq.media.tables.pojos.AiPackCampClass;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;

/**
 * @author 连杰
 */
public class TomatoCoursePackWrapper {
	private TomatoCoursePackWrapper() {
	}

	private String pid;
	private String name;
	private String subName;
	private Integer payType;
	private BigDecimal originMoney;
	private BigDecimal money;
	private Integer tomatoCoin;
	private Integer coin;
	private String target;
	private String suitableArea;
	private String pic;
	private List<String> introPics;
	private List<String> worksPics;
	private String contentPic;
	private Integer videoCnt;
	private Integer studyCnt;
	private String status;
	private Integer saleStatus;
	private Long lastUpdate;
	private Long createTime;
	private Integer type;

	private TeacherInfoWrapper teacher1;
	private TeacherInfoWrapper teacher2;

	private String wechatQr;
	private String wechatCode;

	private Integer coinAble;
	private String shopTip;

	private List<TomatoCourseVideoWrapper> courseVideos;
	private List<CpItemCard> cards;
	private List<AiSerieWrapper> aiSeries;

	private Boolean needPay; // 是否需要付钱
	private Boolean haveContract; // 是否有合同
	private Long endTime; // 到期时间
	private Integer finishCnt;

	private String wid;

	private Boolean reserved;

	// ai课相关
	private Boolean activated; // ai课是否已激活
	private AiPackCampClass campClass; // ai课班级
	private List<AiPackCamp> joinAbleCamps; // 可以参与的ai课的营

	private String bannerUrl;
	private String bannerPic;
	private String productId;

	private Long nextCampTime; // 下次开班时间
	private Long nextOpenLockTime; // 下次解锁时间
	private String lessonName; // ai课次内容
	private Integer aiStatus; // 1即将开始 2今日有课 3今日没课 4全部完成
	private String playAid; // 点击立即学习要跳转的aid

	public static TomatoCoursePackWrapper ofSimple(TomatoCoursePack p) {
		return new TomatoCoursePackWrapper().setPid(p.getPid()).setName(p.getName()).setSubName(p.getSubName())
				.setPayType(p.getPayType()).setOriginMoney(p.getOriginMoney()).setMoney(p.getMoney())
				.setTomatoCoin(p.getCoin()).setCoin(p.getCoin()).setPic(p.getPic()).setVideoCnt(p.getVideoCnt())
				.setStudyCnt(p.getStudyCnt()).setSaleStatus(p.getSaleStatus()).setLastUpdate(p.getLastUpdate())
				.setType(p.getType());
	}

	public static TomatoCoursePackWrapper of(TomatoCoursePack p) {
		return new TomatoCoursePackWrapper().setPid(p.getPid()).setName(p.getName()).setSubName(p.getSubName())
				.setPayType(p.getPayType()).setOriginMoney(p.getOriginMoney()).setMoney(p.getMoney())
				.setTomatoCoin(p.getCoin()).setCoin(p.getCoin()).setTarget(p.getTarget())
				.setSuitableArea(p.getSuitableArea()).setPic(p.getPic()).setIntroPics(p.getIntroPics())
				.setWorksPics(p.getWorksPics()).setContentPic(p.getContentPic()).setVideoCnt(p.getVideoCnt())
				.setStudyCnt(p.getStudyCnt()).setStatus(p.getStatus()).setSaleStatus(p.getSaleStatus())
				.setLastUpdate(p.getLastUpdate()).setCreateTime(p.getCreateTime()).setWid(p.getWid())
				.setType(p.getType()).setWechatQr(p.getWechatQr()).setWechatCode(p.getWechatCode())
				.setCoinAble(p.getCoinAble()).setShopTip(p.getShopTip());
	}

	public String getPid() {
		return pid;
	}

	public TomatoCoursePackWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getName() {
		return name;
	}

	public TomatoCoursePackWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSubName() {
		return subName;
	}

	public TomatoCoursePackWrapper setSubName(String subName) {
		this.subName = subName;
		return this;
	}

	public Integer getPayType() {
		return payType;
	}

	public TomatoCoursePackWrapper setPayType(Integer payType) {
		this.payType = payType;
		return this;
	}

	public BigDecimal getOriginMoney() {
		return originMoney;
	}

	public TomatoCoursePackWrapper setOriginMoney(BigDecimal originMoney) {
		this.originMoney = originMoney;
		return this;
	}

	public BigDecimal getMoney() {
		return money;
	}

	public TomatoCoursePackWrapper setMoney(BigDecimal money) {
		this.money = money;
		return this;
	}

	public Integer getTomatoCoin() {
		return tomatoCoin;
	}

	public TomatoCoursePackWrapper setTomatoCoin(Integer tomatoCoin) {
		this.tomatoCoin = tomatoCoin;
		return this;
	}

	public String getTarget() {
		return target;
	}

	public TomatoCoursePackWrapper setTarget(String target) {
		this.target = target;
		return this;
	}

	public String getSuitableArea() {
		return suitableArea;
	}

	public TomatoCoursePackWrapper setSuitableArea(String suitableArea) {
		this.suitableArea = suitableArea;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public TomatoCoursePackWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public List<String> getIntroPics() {
		return introPics;
	}

	public TomatoCoursePackWrapper setIntroPics(String introPics) {
		this.introPics = Lists.newArrayList();
		if (StringUtils.isNotEmpty(introPics)) {
			for (String wp : StringUtils.split(introPics, ",")) {
				this.introPics.add(AliyunBean.getImagesUrl(wp));
			}
		}
		return this;
	}

	public List<String> getWorksPics() {
		return worksPics;
	}

	public TomatoCoursePackWrapper setWorksPics(String worksPics) {
		this.worksPics = Lists.newArrayList();
		if (StringUtils.isNotEmpty(worksPics)) {
			for (String wp : StringUtils.split(worksPics, ",")) {
				this.worksPics.add(AliyunBean.getImagesUrl(wp));
			}
		}
		return this;
	}

	public String getContentPic() {
		return contentPic;
	}

	public TomatoCoursePackWrapper setContentPic(String contentPic) {
		this.contentPic = AliyunBean.getImagesUrl(contentPic);
		return this;
	}

	public Integer getVideoCnt() {
		return videoCnt;
	}

	public TomatoCoursePackWrapper setVideoCnt(Integer videoCnt) {
		this.videoCnt = videoCnt;
		return this;
	}

	public String getStatus() {
		return status;
	}

	public TomatoCoursePackWrapper setStatus(String status) {
		this.status = status;
		return this;
	}

	public Integer getSaleStatus() {
		return saleStatus;
	}

	public TomatoCoursePackWrapper setSaleStatus(Integer saleStatus) {
		this.saleStatus = saleStatus;
		return this;
	}

	public Long getLastUpdate() {
		return lastUpdate;
	}

	public TomatoCoursePackWrapper setLastUpdate(Long lastUpdate) {
		this.lastUpdate = lastUpdate;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public TomatoCoursePackWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public List<TomatoCourseVideoWrapper> getCourseVideos() {
		return courseVideos;
	}

	public TomatoCoursePackWrapper setCourseVideos(List<TomatoCourseVideoWrapper> courseVideos) {
		this.courseVideos = courseVideos;
		return this;
	}

	public Boolean getNeedPay() {
		return needPay;
	}

	public TomatoCoursePackWrapper setNeedPay(Boolean needPay) {
		this.needPay = needPay;
		return this;
	}

	public Integer getStudyCnt() {
		return studyCnt;
	}

	public TomatoCoursePackWrapper setStudyCnt(Integer studyCnt) {
		this.studyCnt = studyCnt;
		return this;
	}

	public Integer getFinishCnt() {
		return finishCnt;
	}

	public TomatoCoursePackWrapper setFinishCnt(Integer finishCnt) {
		this.finishCnt = finishCnt;
		return this;
	}

	public Integer getCoin() {
		return coin;
	}

	public TomatoCoursePackWrapper setCoin(Integer coin) {
		this.coin = coin;
		return this;
	}

	public String getWid() {
		return wid;
	}

	public TomatoCoursePackWrapper setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public TeacherInfoWrapper getTeacher1() {
		return teacher1;
	}

	public TomatoCoursePackWrapper setTeacher1(TeacherInfoWrapper teacher1) {
		this.teacher1 = teacher1;
		return this;
	}

	public TeacherInfoWrapper getTeacher2() {
		return teacher2;
	}

	public TomatoCoursePackWrapper setTeacher2(TeacherInfoWrapper teacher2) {
		this.teacher2 = teacher2;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public TomatoCoursePackWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public TomatoCoursePackWrapper setType(Integer type) {
		this.type = type;
		return this;
	}

	public Boolean getReserved() {
		return reserved;
	}

	public TomatoCoursePackWrapper setReserved(Boolean reserved) {
		this.reserved = reserved;
		return this;
	}

	public List<CpItemCard> getCards() {
		return cards;
	}

	public TomatoCoursePackWrapper setCards(List<CpItemCard> cards) {
		this.cards = cards;
		return this;
	}

	public String getWechatQr() {
		return wechatQr;
	}

	public TomatoCoursePackWrapper setWechatQr(String wechatQr) {
		this.wechatQr = AliyunBean.getImagesUrl(wechatQr);
		return this;
	}

	public String getWechatCode() {
		return wechatCode;
	}

	public TomatoCoursePackWrapper setWechatCode(String wechatCode) {
		this.wechatCode = wechatCode;
		return this;
	}

	public Boolean getActivated() {
		return activated;
	}

	public TomatoCoursePackWrapper setActivated(Boolean activated) {
		this.activated = activated;
		return this;
	}

	public List<AiSerieWrapper> getAiSeries() {
		return aiSeries;
	}

	public TomatoCoursePackWrapper setAiSeries(List<AiSerieWrapper> aiSeries) {
		this.aiSeries = aiSeries;
		return this;
	}

	public Long getNextCampTime() {
		return nextCampTime;
	}

	public TomatoCoursePackWrapper setNextCampTime(Long nextCampTime) {
		this.nextCampTime = nextCampTime;
		return this;
	}

	public Long getNextOpenLockTime() {
		return nextOpenLockTime;
	}

	public TomatoCoursePackWrapper setNextOpenLockTime(Long nextOpenLockTime) {
		this.nextOpenLockTime = nextOpenLockTime;
		return this;
	}

	public String getLessonName() {
		return lessonName;
	}

	public TomatoCoursePackWrapper setLessonName(String lessonName) {
		this.lessonName = lessonName;
		return this;
	}

	public List<AiPackCamp> getJoinAbleCamps() {
		return joinAbleCamps;
	}

	public TomatoCoursePackWrapper setJoinAbleCamps(List<AiPackCamp> joinAbleCamps) {
		this.joinAbleCamps = joinAbleCamps;
		return this;
	}

	public String getBannerUrl() {
		return bannerUrl;
	}

	public TomatoCoursePackWrapper setBannerUrl(String bannerUrl) {
		this.bannerUrl = bannerUrl;
		return this;
	}

	public String getBannerPic() {
		return bannerPic;
	}

	public TomatoCoursePackWrapper setBannerPic(String bannerPic) {
		this.bannerPic = bannerPic;
		return this;
	}

	public String getProductId() {
		return productId;
	}

	public TomatoCoursePackWrapper setProductId(String productId) {
		this.productId = productId;
		return this;
	}

	public Integer getAiStatus() {
		return aiStatus;
	}

	public TomatoCoursePackWrapper setAiStatus(Integer aiStatus) {
		this.aiStatus = aiStatus;
		return this;
	}

	public String getPlayAid() {
		return playAid;
	}

	public TomatoCoursePackWrapper setPlayAid(String playAid) {
		this.playAid = playAid;
		return this;
	}

	public AiPackCampClass getCampClass() {
		return campClass;
	}

	public TomatoCoursePackWrapper setCampClass(AiPackCampClass campClass) {
		this.campClass = campClass;
		return this;
	}

	public Integer getCoinAble() {
		return coinAble;
	}

	public TomatoCoursePackWrapper setCoinAble(Integer coinAble) {
		this.coinAble = coinAble;
		return this;
	}

	public String getShopTip() {
		return shopTip;
	}

	public TomatoCoursePackWrapper setShopTip(String shopTip) {
		this.shopTip = shopTip;
		return this;
	}

	public Boolean getHaveContract() {
		return haveContract;
	}

	public TomatoCoursePackWrapper setHaveContract(Boolean haveContract) {
		this.haveContract = haveContract;
		return this;
	}

}
