package com.jz.jar.business.wrapper;

import com.alibaba.fastjson.JSONObject;
import com.jz.jooq.media.tables.pojos.AiMaterial;

/**
 * @author 连杰
 */
public class AiMaterialWrapper {
	private AiMaterialWrapper() {
	}

	// 视频信息
	private String materialId;
	private String type;
	private JSONObject data;
	private String snapshotUrl;
	private Integer duration;
	private String hd;

	private String pic;
	private String audio;

	public static AiMaterialWrapper of(AiMaterial m) {
		return new AiMaterialWrapper().setMaterialId(m.getId()).setType(m.getType());
	}

	public String getMaterialId() {
		return materialId;
	}

	public AiMaterialWrapper setMaterialId(String materialId) {
		this.materialId = materialId;
		return this;
	}

	public String getType() {
		return type;
	}

	public AiMaterialWrapper setType(String type) {
		this.type = type;
		return this;
	}

	public JSONObject getData() {
		return data;
	}

	public AiMaterialWrapper setData(JSONObject data) {
		this.data = data;
		return this;
	}

	public String getSnapshotUrl() {
		return snapshotUrl;
	}

	public AiMaterialWrapper setSnapshotUrl(String snapshotUrl) {
		this.snapshotUrl = snapshotUrl;
		return this;
	}

	public Integer getDuration() {
		return duration;
	}

	public AiMaterialWrapper setDuration(Integer duration) {
		this.duration = duration;
		return this;
	}

	public String getHd() {
		return hd;
	}

	public AiMaterialWrapper setHd(String hd) {
		this.hd = hd;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public AiMaterialWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getAudio() {
		return audio;
	}

	public AiMaterialWrapper setAudio(String audio) {
		this.audio = audio;
		return this;
	}

}
