package com.jz.jar.business.proxy.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.wrapper.WWorkTopicTheme;
import com.jz.jar.media.service.WorksThemeRecommService;
import com.jz.jar.media.service.WorksThemeService;
import com.jz.jooq.media.tables.pojos.WorksTheme;
import com.jz.jooq.media.tables.pojos.WorksThemeRecomm;

@Lazy
@Service
public class WorksThemeProxy {

	@Autowired
	private WorksThemeService worksThemeService;
	@Autowired
	private WorksThemeRecommService worksThemeRecommService;

	public Map<String, WWorkTopicTheme> mutiGetWorksThemeWithRecomPic(Collection<String> tids) {
		List<WorksTheme> themes = worksThemeService.mutiGetThemeInfos(tids);

		List<WorksThemeRecomm> recomms = worksThemeRecommService.mutiGetRecommPicsByThemeIds(tids);
		Map<String, String> recomPicMap = Maps.newHashMap();
		for (WorksThemeRecomm recomm : recomms) {
			if (!recomPicMap.containsKey(recomm.getThemeId())) {
				recomPicMap.put(recomm.getThemeId(), recomm.getPic());
			}
		}
		Map<String, WWorkTopicTheme> rsMap = Maps.newHashMap();
		for (WorksTheme t : themes) {
			WWorkTopicTheme wrapper = WWorkTopicTheme.of(t);
			if (recomPicMap.containsKey(t.getId())) {
				wrapper.setPic(AliyunBean.getImagesUrl(recomPicMap.get(t.getId())));
			} else {
				wrapper.setPic(AliyunBean.getImagesUrl(t.getPic()));
			}
			rsMap.put(t.getId(), wrapper);
		}
		return rsMap;
	}

}
