package com.jz.jar.business.card;

import java.util.List;

import com.jz.jar.business.bean.AliyunBean;

/**
 * @author 连杰
 * */
public class ModelCard {
	private String type;
	private String model;
	private String title;
	private List<ItemCard> homeCards;
	private Double ratio;
	private Integer num;
	private String icon;
	private List<Integer> finishDays; // 今日小课专用

	public static ModelCard of(String type) {
		return new ModelCard().setType(type);
	}

	public String getType() {
		return type;
	}

	public ModelCard setType(String type) {
		this.type = type;
		return this;
	}

	public String getModel() {
		return model;
	}

	public ModelCard setModel(String model) {
		this.model = model;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public ModelCard setTitle(String title) {
		this.title = title;
		return this;
	}

	public List<ItemCard> getHomeCards() {
		return homeCards;
	}

	public ModelCard setHomeCards(List<ItemCard> homeCards) {
		this.homeCards = homeCards;
		return this;
	}

	public Double getRatio() {
		return ratio;
	}

	public ModelCard setRatio(Double ratio) {
		this.ratio = ratio;
		return this;
	}

	public Integer getNum() {
		return num;
	}

	public ModelCard setNum(Integer num) {
		this.num = num;
		return this;
	}

	public String getIcon() {
		return icon;
	}

	public ModelCard setIcon(String icon) {
		this.icon = AliyunBean.getImagesUrl(icon);
		return this;
	}

	public List<Integer> getFinishDays() {
		return finishDays;
	}

	public ModelCard setFinishDays(List<Integer> finishDays) {
		this.finishDays = finishDays;
		return this;
	}

}
