/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.request.TomatoCoursePackRequest;
import com.jz.jar.business.wrapper.TeacherInfoWrapper;
import com.jz.jar.business.wrapper.TomatoCoursePackWrapper;
import com.jz.jar.business.wrapper.TomatoCourseWorksWrapper;
import com.jz.jar.business.wrapper.WLessonReport;
import com.jz.jar.media.service.TeacherInfoService;
import com.jz.jar.media.service.TomatoCoursePackService;
import com.jz.jar.media.service.TomatoCourseWorksService;
import com.jz.jar.media.service.UserAiService;
import com.jz.jar.media.service.UserCourseService;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorks;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorksScoreSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TomatoCoursePackProxy {
    @Autowired
    private TomatoCoursePackService tomatoCoursePackService;
    @Autowired
    private UserCourseService userCourseService;
    @Autowired
    private TeacherInfoService teacherInfoService;
    @Autowired
    private TomatoCourseWorksService tomatoCourseWorksService;
    @Autowired
    private UserAiService userAiService;

    public List<TomatoCoursePackWrapper> mutiGetSimplePack(TomatoCoursePackRequest request) {
        if (ArrayMapTools.isEmpty(request.getPids())) {
            return null;
        }
        List packs = this.tomatoCoursePackService.mutiGetOnlinePack(request.getPids(), request.getBrand());
        HashMap finishMap = null;
        if (request.isWithFinishCnt() && StringUtils.isNotEmpty((String)request.getSuid())) {
            ArrayList aidPids = Lists.newArrayList();
            ArrayList normalPids = Lists.newArrayList();
            for (TomatoCoursePack p : packs) {
                if (p.getType() == 4) {
                    aidPids.add(p.getPid());
                    continue;
                }
                normalPids.add(p.getPid());
            }
            finishMap = Maps.newHashMap();
            if (normalPids.size() > 0) {
                finishMap.putAll(this.userCourseService.mutiCalFinishCnt(request.getSuid(), request.getBrand(), (Collection)normalPids));
            }
            if (aidPids.size() > 0) {
                finishMap.putAll(this.userAiService.mutiCalFinishNum(request.getSuid(), (Collection)aidPids));
            }
        }
        HashSet teacherIds = Sets.newHashSet();
        for (TomatoCoursePack p : packs) {
            if (StringUtils.isNotEmpty((String)p.getTeacher1())) {
                teacherIds.add(p.getTeacher1());
            }
            if (!StringUtils.isNotEmpty((String)p.getTeacher2())) continue;
            teacherIds.add(p.getTeacher2());
        }
        Map<String, TeacherInfoWrapper> teacherMap = null;
        if (teacherIds.size() > 0) {
            teacherMap = this.teacherInfoService.mutiGetSimpleTeachers((Collection)teacherIds).stream().collect(Collectors.toMap(t -> t.getId(), t -> TeacherInfoWrapper.of(t)));
        }
        ArrayList wrappers = Lists.newArrayList();
        for (TomatoCoursePack p : packs) {
            TomatoCoursePackWrapper wrapper = TomatoCoursePackWrapper.ofSimple(p);
            if (request.isWithFinishCnt()) {
                int finishCnt = MapUtils.getIntValue((Map)finishMap, (Object)p.getPid());
                if (finishCnt >= p.getVideoCnt()) {
                    finishCnt = -1;
                }
                wrapper.setFinishCnt(finishCnt);
            }
            if (StringUtils.isNotEmpty((String)p.getTeacher1()) && teacherMap != null) {
                wrapper.setTeacher1(teacherMap.get(p.getTeacher1()));
            }
            if (StringUtils.isNotEmpty((String)p.getTeacher2()) && teacherMap != null) {
                wrapper.setTeacher2(teacherMap.get(p.getTeacher2()));
            }
            wrappers.add(wrapper);
        }
        if (request.isKeepOrder()) {
            return OrderTool.keepOrder(request.getPids(), (Collection)wrappers, TomatoCoursePackWrapper::getPid);
        }
        return wrappers;
    }

    public Map<String, TomatoCoursePackWrapper> mutiGetSimplePackMap(TomatoCoursePackRequest request) {
        request.setKeepOrder(false);
        List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().collect(Collectors.toMap(p -> p.getPid(), p -> p));
    }

    public List<ItemCard> mutiGetPackCards(TomatoCoursePackRequest request) {
        List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public Map<String, ItemCard> mutiGetPackCardMap(TomatoCoursePackRequest request) {
        request.setKeepOrder(false);
        List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().collect(Collectors.toMap(p -> p.getPid(), p -> ItemCard.of(p)));
    }

    public TomatoCourseWorksWrapper getCourseWorksWithReport(String wid, String suid, int learnInfoStatus) {
        TomatoCourseWorks works = this.tomatoCourseWorksService.getWorksByWidSuid(wid, suid);
        if (works == null) {
            return null;
        }
        TomatoCourseWorksWrapper worksWrapper = TomatoCourseWorksWrapper.of(works);
        if (learnInfoStatus == 2) {
            Map<String, Integer> scores = this.tomatoCourseWorksService.getWorksScore(works.getId()).stream().collect(Collectors.toMap(s -> s.getName(), s -> s.getStarCnt()));
            List settings = this.tomatoCourseWorksService.listScoreSettings();
            LinkedHashMap name2Report = Maps.newLinkedHashMap();
            for (TomatoCourseWorksScoreSetting setting : settings) {
                if (!scores.containsKey(setting.getName())) continue;
                int starCnt = scores.get(setting.getName());
                String ctx = "";
                if (starCnt <= 1) {
                    ctx = setting.getStar1();
                    starCnt = 1;
                } else if (starCnt == 2) {
                    ctx = setting.getStar2();
                } else if (starCnt == 3) {
                    ctx = setting.getStar3();
                } else {
                    ctx = setting.getStar4();
                    starCnt = 4;
                }
                if (name2Report.containsKey(setting.getName())) {
                    ((WLessonReport)name2Report.get(setting.getName())).addReport(setting.getDimension(), ctx);
                    continue;
                }
                name2Report.put(setting.getName(), WLessonReport.of(setting.getName(), starCnt).addReport(setting.getDimension(), ctx));
            }
            worksWrapper.setLessonReports(name2Report.values());
        }
        return worksWrapper;
    }
}

