package com.jz.jar.business.wrapper;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiPart;

public class TomatoCourseAiPartWrapper {

	private String partId;
	private String name;
	private String subName;
	private String icon;
	private String iconGray;
	private Integer partStatus; // 0学习中 1已完成 -1未解锁

	public static TomatoCourseAiPartWrapper of(TomatoCourseAiPart p) {
		return new TomatoCourseAiPartWrapper().setPartId(p.getPartId()).setName(p.getName()).setSubName(p.getSubName())
				.setIcon(p.getIcon()).setIconGray(p.getIconGray());
	}

	public String getPartId() {
		return partId;
	}

	public TomatoCourseAiPartWrapper setPartId(String partId) {
		this.partId = partId;
		return this;
	}

	public String getName() {
		return name;
	}

	public TomatoCourseAiPartWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSubName() {
		return subName;
	}

	public TomatoCourseAiPartWrapper setSubName(String subName) {
		this.subName = subName;
		return this;
	}

	public String getIcon() {
		return icon;
	}

	public TomatoCourseAiPartWrapper setIcon(String icon) {
		this.icon = AliyunBean.getImagesUrl(icon);
		return this;
	}

	public String getIconGray() {
		return iconGray;
	}

	public TomatoCourseAiPartWrapper setIconGray(String iconGray) {
		this.iconGray = AliyunBean.getImagesUrl(iconGray);
		return this;
	}

	public Integer getPartStatus() {
		return partStatus;
	}

	public TomatoCourseAiPartWrapper setPartStatus(Integer partStatus) {
		this.partStatus = partStatus;
		return this;
	}

}
