/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.bean.MediaGlobal;
import com.jz.jar.business.enums.PictureCompress;
import com.jz.jar.business.proxy.common.LevelProxy;
import com.jz.jar.business.proxy.common.PlayTitleProxy;
import com.jz.jar.business.request.UserRequest;
import com.jz.jar.business.wrapper.StudentWrapper;
import com.jz.jar.business.wrapper.UserWrapper;
import com.jz.jar.franchise.service.ContractService;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.service.StudentRelParentService;
import com.jz.jar.franchise.service.StudentSchoolContractService;
import com.jz.jar.franchise.service.StudentSchoolService;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.FansRelationService;
import com.jz.jar.media.service.UserCoinService;
import com.jz.jar.media.service.UserSignService;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.media.tables.pojos.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UserProxy {
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private StudentRelParentService studentRelParentService;
    @Autowired
    private StudentSchoolService studentSchoolService;
    @Autowired
    private StudentSchoolContractService studentSchoolContractService;
    @Autowired
    private UserSignService userSignService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private LevelProxy levelProxy;
    @Autowired
    private ParentInfoService parentInfoService;
    @Autowired
    private FansRelationService fansRelationService;
    @Autowired
    private PlayTitleProxy playTitleProxy;
    @Autowired
    private UserCoinService userCoinService;

    public UserWrapper getUserInfo(String uid, BrandEnum brand, boolean isMaster, boolean isMy) {
        ParentInfo parentInfo = this.parentInfoService.getParentInfoForId(uid);
        if (null == parentInfo) {
            return null;
        }
        UserWrapper user = UserWrapper.of(parentInfo);
        if (isMaster) {
            user.setPhone(MediaGlobal.getPhone(parentInfo.getPhone()));
        }
        user.setAvatar(UserProxy.getUserAvatar(parentInfo, isMy));
        Pair relationCnt = this.fansRelationService.getRelationCnt(brand, uid);
        user.setFansCnt((Integer)relationCnt.getLeft()).setFollowCnt((Integer)relationCnt.getRight());
        user.setStudents(this.getStudentsInfo(parentInfo.getPuid(), brand));
        int coin = this.userCoinService.getUserCurrentCoin(uid, brand.name());
        user.setTomatoCoin(coin).setCoin(coin);
        return user;
    }

    public <T> T getSimpleParentInfo(BrandEnum brand, UserRequest request) {
        boolean isSingle;
        if (null == request || StringTools.isEmpty((CharSequence)request.getPuid()) && ArrayMapTools.isEmpty(request.getPuids())) {
            return null;
        }
        if (null == request.getBrand()) {
            request.setBrand(brand);
        }
        if (isSingle = ArrayMapTools.isEmpty(request.getPuids())) {
            request.setPuids(Arrays.asList(request.getPuid()));
        }
        List<UserWrapper> users = this.getSimpleParentInfo(request);
        if (isSingle) {
            return (T)ArrayMapTools.getFirst(users);
        }
        return (T)users;
    }

    public List<UserWrapper> getSimpleParentInfo(UserRequest request) {
        List studentInfos;
        List parentInfos = this.parentInfoService.getSimpleParentInfo(request.getPuids());
        if (ArrayMapTools.isEmpty((Collection)parentInfos)) {
            return null;
        }
        HashMap puid2StudnetInfo = Maps.newHashMap();
        if (request.isWithChildren() && ArrayMapTools.isNotEmpty((Collection)(studentInfos = this.studentInfoService.getSimpleStudentInfo(request.getPuids())))) {
            studentInfos.forEach(it -> {
                if (!puid2StudnetInfo.containsKey(it.getPuid())) {
                    puid2StudnetInfo.put(it.getPuid(), Lists.newArrayList());
                }
                StudentWrapper student = StudentWrapper.of(it);
                student.setAge(this.getShowStudentAge((StudentInfo)it, false));
                student.setAvatar(AliyunBean.getImagesUrl(it.getAvatar(), PictureCompress._30));
                ((List)puid2StudnetInfo.get(it.getPuid())).add(student);
            });
        }
        List followUids = null;
        if (null != request.getUid()) {
            followUids = this.fansRelationService.screenMyFollow(request.getBrand(), request.getUid(), request.getPuids());
        }
        ArrayList users = Lists.newArrayList();
        for (ParentInfo it2 : parentInfos) {
            UserWrapper user = UserWrapper.of(it2);
            if (null != followUids) {
                user.setIsFollow(followUids.contains(it2.getPuid()));
            }
            user.setAvatar(UserProxy.getUserAvatar(it2, false));
            if (puid2StudnetInfo.containsKey(it2.getPuid())) {
                user.setStudents((List)puid2StudnetInfo.get(it2.getPuid()));
            }
            users.add(user);
        }
        return OrderTool.keepOrder(request.getPuids(), (Collection)users, UserWrapper::getUid);
    }

    public Map<String, UserWrapper> getSimpleParentInfoHas(BrandEnum brand, UserRequest request) {
        List users = (List)this.getSimpleParentInfo(brand, request);
        if (ArrayMapTools.isEmpty((Collection)users)) {
            return Maps.newHashMap();
        }
        HashMap uid2User = Maps.newHashMap();
        users.forEach(it -> uid2User.put(it.getUid(), it));
        return uid2User;
    }

    public Level getLevelForAge(String suid, BrandEnum brand) {
        if (StringTools.isEmptyAndBlank((String)suid)) {
            return null;
        }
        String birthday = this.studentInfoService.getStudentBirthday(suid);
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return null;
        }
        return this.levelProxy.getLevelForAge(MediaGlobal.getAge(birthday).floatValue(), brand);
    }

    public String getLidForBirthday(String birthday, BrandEnum brand) {
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return null;
        }
        Level level = this.levelProxy.getLevelForAge(MediaGlobal.getAge(birthday).floatValue(), brand);
        if (null == level) {
            return null;
        }
        return level.getLid();
    }

    public List<StudentWrapper> getStudentsInfo(String puid, BrandEnum brand) {
        List otherSuids = this.studentRelParentService.getSuidsByRelPuid(puid);
        List students = null;
        students = ArrayMapTools.isNotEmpty((Collection)otherSuids) ? this.studentInfoService.getStudentsForPuidAndOtherSuids(puid, (Collection)otherSuids) : this.studentInfoService.getStudents(puid);
        if (ArrayMapTools.isEmpty((Collection)students)) {
            return null;
        }
        List suids = students.stream().map(it -> it.getSuid()).collect(Collectors.toList());
        Map suid2Cnt = null;
        Map hasLession = null;
        ArrayList containSchoolSuids = Lists.newArrayList();
        if (brand == BrandEnum.playabc) {
            suid2Cnt = this.userSignService.getCountDays(puid, suids);
            List schoolIds = this.contractService.getSchoolIds(brand.name(), puid);
            if (ArrayMapTools.isNotEmpty((Collection)schoolIds)) {
                hasLession = this.studentSchoolContractService.getLessionCount(suids, (Collection)schoolIds);
            }
        }
        containSchoolSuids.addAll(this.studentSchoolService.getContainsSchool(suids));
        boolean isHaveContract = ArrayMapTools.isNotEmpty((Collection)otherSuids) ? true : this.contractService.isHaveContract(brand.name(), puid);
        boolean isOwnedContract = ArrayMapTools.isNotEmpty((Collection)otherSuids) ? true : this.contractService.isOwnedContract(brand.name(), puid);
        ArrayList wrappers = Lists.newArrayList();
        for (StudentInfo st : students) {
            boolean isRelChild = false;
            if (ArrayMapTools.isNotEmpty((Collection)otherSuids)) {
                isRelChild = !StringUtils.equals((CharSequence)st.getPuid(), (CharSequence)puid);
            }
            wrappers.add(this.getWrapper(st, (Integer)MediaGlobal.getMapValue(suid2Cnt, st.getSuid()), (Pair<Integer, Integer>)((Pair)MediaGlobal.getMapValue(hasLession, st.getSuid())), containSchoolSuids.contains(st.getSuid()), isHaveContract, isOwnedContract, false, false, brand, isRelChild));
        }
        return wrappers;
    }

    public StudentWrapper getStudentInfo(String suid, boolean isSimple, BrandEnum brand) {
        StudentInfo st = this.studentInfoService.getStudent(suid);
        if (null == st) {
            return null;
        }
        boolean isContainsSchool = this.studentSchoolService.isContainsSchool(suid);
        boolean isHaveContract = this.contractService.isHaveContract(brand.name(), st.getPuid());
        boolean isOwnedContract = this.contractService.isOwnedContract(brand.name(), st.getPuid());
        if (isSimple || brand == BrandEnum.tomato) {
            return this.getWrapper(st, null, null, isContainsSchool, isHaveContract, isOwnedContract, true, false, brand, false);
        }
        Pair lessCnt = null;
        List schoolIds = this.contractService.getSchoolIds(brand.name(), st.getPuid());
        if (ArrayMapTools.isNotEmpty((Collection)schoolIds)) {
            lessCnt = this.studentSchoolContractService.getLessionCount(st.getSuid(), (Collection)schoolIds);
        }
        int signCnt = this.userSignService.countDays(st.getPuid(), suid);
        return this.getWrapper(st, signCnt, (Pair<Integer, Integer>)lessCnt, isContainsSchool, isHaveContract, isOwnedContract, false, false, brand, false);
    }

    public List<StudentWrapper> getStudentSimpleInfo(Collection<String> suids, BrandEnum brand) {
        if (ArrayMapTools.isEmpty(suids)) {
            return null;
        }
        List students = this.studentInfoService.getSimpleStudentInfoForSuid(suids);
        if (ArrayMapTools.isEmpty((Collection)students)) {
            return null;
        }
        ArrayList sw = Lists.newArrayList();
        for (StudentInfo st : students) {
            sw.add(this.getWrapper(st, null, null, false, false, false, false, true, brand, false));
        }
        return sw;
    }

    public Map<String, StudentWrapper> getStudentSimpleInfoHasForSuid(Collection<String> suids, BrandEnum brand) {
        List<StudentWrapper> students = this.getStudentSimpleInfo(suids, brand);
        if (ArrayMapTools.isEmpty(students)) {
            return null;
        }
        return students.stream().collect(Collectors.toMap(it -> it.getSuid(), it -> it));
    }

    private StudentWrapper getWrapper(StudentInfo st, Integer signCnt, Pair<Integer, Integer> lessionCount, boolean isContainSchool, boolean isHaveContract, boolean isOwnedContract, boolean isSimple, boolean justBaseInfo, BrandEnum brand, boolean isRelChild) {
        StudentWrapper student = StudentWrapper.of(st).setAge(this.getShowStudentAge(st, true)).setAvatar(UserProxy.getStudentAvatar(st, brand));
        if (justBaseInfo) {
            return student;
        }
        student.setLevel(this.getLidForBirthday(st.getBirthday(), brand)).setSignCnt(signCnt).setIsContainSchool(isContainSchool).setQrCode(UserProxy.getQRCode(st.getSuid()));
        if (isRelChild) {
            student.setIsHaveContract(true);
            student.setIsOwnedContract(true);
        } else {
            student.setIsHaveContract(isHaveContract);
            student.setIsOwnedContract(isOwnedContract);
        }
        student.setIsRelChild(isRelChild);
        if (isSimple || brand == BrandEnum.tomato) {
            return student;
        }
        if (null != student.getSignCnt()) {
            student.setPlayTitle(this.playTitleProxy.getTitle(student.getSignCnt()));
        }
        if (null == lessionCount) {
            return student.setTotalLession(0).setRemainingLession(0);
        }
        student.setTotalLession((Integer)lessionCount.getLeft()).setRemainingLession((Integer)lessionCount.getLeft() - (Integer)lessionCount.getRight());
        return student;
    }

    public String getShowStudentAge(StudentInfo studentInfo, boolean isShowMonth) {
        if (null == studentInfo || StringTools.isEmptyAndBlank((String)studentInfo.getBirthday())) {
            return null;
        }
        Pair<Integer, Integer> yearOfMonth = MediaGlobal.getAgeMonth(studentInfo.getBirthday());
        StringBuffer sb = new StringBuffer().append(UserProxy.getAgeContent((Integer)yearOfMonth.getLeft(), "\u5c81"));
        if (isShowMonth) {
            sb.append(UserProxy.getAgeContent((Integer)yearOfMonth.getRight(), "\u4e2a\u6708"));
        }
        return sb.toString();
    }

    private static String getAgeContent(int num, String content) {
        return num <= 0 ? "" : num + content;
    }

    private static String getQRCode(String suid) {
        return "childInfo?suid=" + suid;
    }

    private static String getUserAvatar(ParentInfo parent, boolean isMy) {
        if (StringTools.isNotEmpty((CharSequence)parent.getAvatar())) {
            return AliyunBean.getImagesUrl(parent.getAvatar(), PictureCompress._60);
        }
        return AliyunBean.getImagesUrl(isMy ? "fuser/my_parents1.png" : "fuser/parents.png");
    }

    private static String getStudentAvatar(StudentInfo student, BrandEnum brand) {
        if (StringTools.isNotEmpty((CharSequence)student.getAvatar())) {
            return AliyunBean.getImagesUrl(student.getAvatar(), PictureCompress._60);
        }
        String avatar = null;
        if (brand == BrandEnum.playabc) {
            avatar = "fuser/p_girl.png";
            if ("\u7537".equals(student.getSex())) {
                avatar = "fuser/p_boy.png";
            }
        } else {
            avatar = "fuser/girl1.png";
            if ("\u7537".equals(student.getSex())) {
                avatar = "fuser/boy1.png";
            }
        }
        return AliyunBean.getImagesUrl(avatar);
    }
}

