package com.jz.jar.business.tool;

import java.util.Map;

import com.google.common.collect.Maps;

public class SecretTool {

	public static String encode(String str) {
		Map<Character, Character> encodeCharMap = Maps.newHashMap();
		encodeCharMap.put('0', 'q');
		encodeCharMap.put('1', 'F');
		encodeCharMap.put('2', 'W');
		encodeCharMap.put('3', 'B');
		encodeCharMap.put('4', 'h');
		encodeCharMap.put('5', 'N');
		encodeCharMap.put('6', 'e');
		encodeCharMap.put('7', 'f');
		encodeCharMap.put('8', 'z');
		encodeCharMap.put('9', 'j');
		encodeCharMap.put('a', 'c');
		encodeCharMap.put('b', 'T');
		encodeCharMap.put('c', '6');
		encodeCharMap.put('d', 'K');
		encodeCharMap.put('e', 'o');
		encodeCharMap.put('f', '7');
		encodeCharMap.put('g', 'b');
		encodeCharMap.put('h', 'G');
		encodeCharMap.put('i', 'y');
		encodeCharMap.put('j', 'D');
		encodeCharMap.put('k', 'C');
		encodeCharMap.put('l', 'I');
		encodeCharMap.put('m', 'M');
		encodeCharMap.put('n', 'V');
		encodeCharMap.put('o', 'A');
		encodeCharMap.put('p', 't');
		encodeCharMap.put('q', '8');
		encodeCharMap.put('r', 'k');
		encodeCharMap.put('s', 'U');
		encodeCharMap.put('t', 's');
		encodeCharMap.put('u', 'w');
		encodeCharMap.put('v', '4');
		encodeCharMap.put('w', 'i');
		encodeCharMap.put('x', 'p');
		encodeCharMap.put('y', 'a');
		encodeCharMap.put('z', 'd');
		encodeCharMap.put('A', '9');
		encodeCharMap.put('B', 'O');
		encodeCharMap.put('C', 'Q');
		encodeCharMap.put('D', 'P');
		encodeCharMap.put('E', 'Z');
		encodeCharMap.put('F', 'v');
		encodeCharMap.put('G', '2');
		encodeCharMap.put('H', 'L');
		encodeCharMap.put('I', 'X');
		encodeCharMap.put('J', 'n');
		encodeCharMap.put('K', 'R');
		encodeCharMap.put('L', '0');
		encodeCharMap.put('M', '1');
		encodeCharMap.put('N', 'g');
		encodeCharMap.put('O', 'E');
		encodeCharMap.put('P', '5');
		encodeCharMap.put('Q', 'H');
		encodeCharMap.put('R', 'u');
		encodeCharMap.put('S', 'l');
		encodeCharMap.put('T', 'm');
		encodeCharMap.put('U', 'J');
		encodeCharMap.put('V', 'S');
		encodeCharMap.put('W', 'Y');
		encodeCharMap.put('X', 'x');
		encodeCharMap.put('Y', 'r');
		encodeCharMap.put('Z', '3');

		if (str == null || str.length() < 20 || !str.contains("/")) {
			return str;
		}

		String start = str.substring(0, str.indexOf("/", 20));
		String end = str.substring(str.lastIndexOf("/"), str.length());
		String mid = str.substring(str.indexOf("/", 20), str.lastIndexOf("/"));
		StringBuffer midSb = new StringBuffer();
		for (char c : mid.toCharArray()) {
			if (encodeCharMap.containsKey(c)) {
				midSb.append(encodeCharMap.get(c));
			} else {
				midSb.append(c);
			}
		}
		return start + midSb.toString() + end;
	}

	public static String decode(String str) {
		Map<Character, Character> decodeCharMap = Maps.newHashMap();
		decodeCharMap.put('q', '0');
		decodeCharMap.put('F', '1');
		decodeCharMap.put('W', '2');
		decodeCharMap.put('B', '3');
		decodeCharMap.put('h', '4');
		decodeCharMap.put('N', '5');
		decodeCharMap.put('e', '6');
		decodeCharMap.put('f', '7');
		decodeCharMap.put('z', '8');
		decodeCharMap.put('j', '9');
		decodeCharMap.put('c', 'a');
		decodeCharMap.put('T', 'b');
		decodeCharMap.put('6', 'c');
		decodeCharMap.put('K', 'd');
		decodeCharMap.put('o', 'e');
		decodeCharMap.put('7', 'f');
		decodeCharMap.put('b', 'g');
		decodeCharMap.put('G', 'h');
		decodeCharMap.put('y', 'i');
		decodeCharMap.put('D', 'j');
		decodeCharMap.put('C', 'k');
		decodeCharMap.put('I', 'l');
		decodeCharMap.put('M', 'm');
		decodeCharMap.put('V', 'n');
		decodeCharMap.put('A', 'o');
		decodeCharMap.put('t', 'p');
		decodeCharMap.put('8', 'q');
		decodeCharMap.put('k', 'r');
		decodeCharMap.put('U', 's');
		decodeCharMap.put('s', 't');
		decodeCharMap.put('w', 'u');
		decodeCharMap.put('4', 'v');
		decodeCharMap.put('i', 'w');
		decodeCharMap.put('p', 'x');
		decodeCharMap.put('a', 'y');
		decodeCharMap.put('d', 'z');
		decodeCharMap.put('9', 'A');
		decodeCharMap.put('O', 'B');
		decodeCharMap.put('Q', 'C');
		decodeCharMap.put('P', 'D');
		decodeCharMap.put('Z', 'E');
		decodeCharMap.put('v', 'F');
		decodeCharMap.put('2', 'G');
		decodeCharMap.put('L', 'H');
		decodeCharMap.put('X', 'I');
		decodeCharMap.put('n', 'J');
		decodeCharMap.put('R', 'K');
		decodeCharMap.put('0', 'L');
		decodeCharMap.put('1', 'M');
		decodeCharMap.put('g', 'N');
		decodeCharMap.put('E', 'O');
		decodeCharMap.put('5', 'P');
		decodeCharMap.put('H', 'Q');
		decodeCharMap.put('u', 'R');
		decodeCharMap.put('l', 'S');
		decodeCharMap.put('m', 'T');
		decodeCharMap.put('J', 'U');
		decodeCharMap.put('S', 'V');
		decodeCharMap.put('Y', 'W');
		decodeCharMap.put('x', 'X');
		decodeCharMap.put('r', 'Y');
		decodeCharMap.put('3', 'Z');

		if (str == null || str.length() < 20 || !str.contains("/")) {
			return str;
		}
		String start = str.substring(0, str.indexOf("/", 20));
		String end = str.substring(str.lastIndexOf("/"), str.length());
		String mid = str.substring(str.indexOf("/", 20), str.lastIndexOf("/"));
		StringBuffer midSb = new StringBuffer();
		for (char c : mid.toCharArray()) {
			if (decodeCharMap.containsKey(c)) {
				midSb.append(decodeCharMap.get(c));
			} else {
				midSb.append(c);
			}
		}
		return start + midSb.toString() + end;
	}

	public static void main(String[] args) {
		String str = "https://video.gymchina.com/46a69268aa8ea1d4ae509c181b1ba355/5E5E3613/tomato/video/train_tzlqdhfwjff94mk4/hd.mp4";
		String encodeStr = encode(str);
		System.out.println(encodeStr);
		String decodeStr = decode(encodeStr);
		System.out.println(decodeStr);
	}

}
