package com.jz.jar.business.wrapper;

import com.jz.jooq.media.tables.pojos.TomatoCourseVideo;

/**
 * @author 连杰
 */
public class TomatoCourseVideoWrapper {
	private TomatoCourseVideoWrapper() {
	}

	// 视频信息
	private String wid;
	private String name;
	private String content;
	private String goal;
	private Boolean haveHomework;
	private String homework;
	private Boolean isFree;
	private String dar;
	private Integer duration;
	private String hd;
	private String normal;
	private String low;
	private String audit;
	private String snapshotUrl;
	private Long createTime;
	private Long lastUpdate;

	private String episodeName;

	private String pid;

	// 上次播放时长
	private Integer playLength;
	// 学习进度
	private Integer maxPlayLength;
	// 学习状态
	private Integer learnStatus;
	// 是否需要解码
	private Boolean needDecode;

	private Boolean locked;

	public static TomatoCourseVideoWrapper of(TomatoCourseVideo video, int type) {
		return new TomatoCourseVideoWrapper().setWid(video.getWid()).setName(video.getName())
				.setContent(video.getContent()).setGoal(video.getGoal()).setHaveHomework(video.getHaveHomework() > 0)
				.setHomework(video.getHomework()).setDar(video.getDar()).setDuration(video.getDuration())
				.setCreateTime(video.getCreateTime()).setLastUpdate(video.getLastUpdate()).setIsFree(type == 0); // 0免费1付费
	}

	public String getWid() {
		return wid;
	}

	public TomatoCourseVideoWrapper setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public String getName() {
		return name;
	}

	public TomatoCourseVideoWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getDar() {
		return dar;
	}

	public TomatoCourseVideoWrapper setDar(String dar) {
		this.dar = dar;
		return this;
	}

	public Integer getDuration() {
		return duration;
	}

	public TomatoCourseVideoWrapper setDuration(Integer duration) {
		this.duration = duration;
		return this;
	}

	public String getHd() {
		return hd;
	}

	public TomatoCourseVideoWrapper setHd(String hd) {
		this.hd = hd;
		return this;
	}

	public String getNormal() {
		return normal;
	}

	public TomatoCourseVideoWrapper setNormal(String normal) {
		this.normal = normal;
		return this;
	}

	public String getLow() {
		return low;
	}

	public TomatoCourseVideoWrapper setLow(String low) {
		this.low = low;
		return this;
	}

	public String getAudit() {
		return audit;
	}

	public TomatoCourseVideoWrapper setAudit(String audit) {
		this.audit = audit;
		return this;
	}

	public String getSnapshotUrl() {
		return snapshotUrl;
	}

	public TomatoCourseVideoWrapper setSnapshotUrl(String snapshotUrl) {
		this.snapshotUrl = snapshotUrl;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public TomatoCourseVideoWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public Long getLastUpdate() {
		return lastUpdate;
	}

	public TomatoCourseVideoWrapper setLastUpdate(Long lastUpdate) {
		this.lastUpdate = lastUpdate;
		return this;
	}

	public Integer getPlayLength() {
		return playLength;
	}

	public TomatoCourseVideoWrapper setPlayLength(Integer playLength) {
		this.playLength = playLength;
		return this;
	}

	public Integer getMaxPlayLength() {
		return maxPlayLength;
	}

	public TomatoCourseVideoWrapper setMaxPlayLength(Integer maxPlayLength) {
		this.maxPlayLength = maxPlayLength;
		return this;
	}

	public String getContent() {
		return content;
	}

	public TomatoCourseVideoWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public String getGoal() {
		return goal;
	}

	public TomatoCourseVideoWrapper setGoal(String goal) {
		this.goal = goal;
		return this;
	}

	public String getHomework() {
		return homework;
	}

	public TomatoCourseVideoWrapper setHomework(String homework) {
		this.homework = homework;
		return this;
	}

	public Boolean getIsFree() {
		return isFree;
	}

	public TomatoCourseVideoWrapper setIsFree(Boolean isFree) {
		this.isFree = isFree;
		return this;
	}

	public Integer getLearnStatus() {
		return learnStatus;
	}

	public TomatoCourseVideoWrapper setLearnStatus(Integer learnStatus) {
		this.learnStatus = learnStatus;
		return this;
	}

	public Boolean getNeedDecode() {
		return needDecode;
	}

	public TomatoCourseVideoWrapper setNeedDecode(Boolean needDecode) {
		this.needDecode = needDecode;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public TomatoCourseVideoWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public Boolean getHaveHomework() {
		return haveHomework;
	}

	public TomatoCourseVideoWrapper setHaveHomework(Boolean haveHomework) {
		this.haveHomework = haveHomework;
		return this;
	}

	public String getEpisodeName() {
		return episodeName;
	}

	public TomatoCourseVideoWrapper setEpisodeName(String episodeName) {
		this.episodeName = episodeName;
		return this;
	}

	public Boolean getLocked() {
		return locked;
	}

	public TomatoCourseVideoWrapper setLocked(Boolean locked) {
		this.locked = locked;
		return this;
	}
}
