/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.search.entity.business.tomato;

import com.jz.jar.media.enums.PlaylistType;
import com.jz.jar.search.entity.base.AliOpenSearchBase;
import com.jz.jar.search.entity.business.tomato.TomatoSearchType;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;
import com.jz.jooq.media.tables.pojos.TomatoImageText;
import java.util.List;

public class ETomatoSearchBean
extends AliOpenSearchBase {
    private String id;
    private String name;
    private Integer type;
    private Integer timer;
    private List<String> attrs;

    public static ETomatoSearchBean of(String id) {
        return new ETomatoSearchBean().setId(id);
    }

    public static ETomatoSearchBean of(Playlist playlist) {
        ETomatoSearchBean bean = new ETomatoSearchBean().setId(playlist.getPid()).setName(playlist.getName()).setTimer(playlist.getLastUpdate());
        if (PlaylistType.video.isEqualsName(playlist.getType())) {
            bean.setType(TomatoSearchType.video_playlist);
        } else {
            bean.setType(TomatoSearchType.img_txt_playlist);
        }
        return bean;
    }

    public static ETomatoSearchBean of(MediaVideo video) {
        return new ETomatoSearchBean().setId(video.getWid()).setName(video.getName()).setTimer(video.getLastUpdate()).setType(TomatoSearchType.video);
    }

    public static ETomatoSearchBean of(TomatoImageText imageText) {
        return new ETomatoSearchBean().setId(imageText.getId()).setName(imageText.getName()).setTimer(imageText.getLastUpdated()).setType(TomatoSearchType.img_txt);
    }

    public static ETomatoSearchBean of(TomatoCoursePack pack) {
        return new ETomatoSearchBean().setId(pack.getPid()).setName(pack.getName()).setTimer(pack.getLastUpdate()).setType(TomatoSearchType.course_pack);
    }

    public String getId() {
        return this.id;
    }

    public ETomatoSearchBean setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ETomatoSearchBean setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getType() {
        return this.type;
    }

    public ETomatoSearchBean setType(TomatoSearchType type) {
        this.type = type.getCode();
        return this;
    }

    public Integer getTimer() {
        return this.timer;
    }

    public ETomatoSearchBean setTimer(Long timer) {
        this.timer = (int)(timer / 1000L);
        return this;
    }

    public List<String> getAttrs() {
        return this.attrs;
    }

    public ETomatoSearchBean setAttrs(List<String> attrs) {
        this.attrs = attrs;
        return this;
    }
}

