package com.jz.jar.business.proxy.common;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.request.TomatoCoursePackRequest;
import com.jz.jar.business.wrapper.TeacherInfoWrapper;
import com.jz.jar.business.wrapper.TomatoCoursePackWrapper;
import com.jz.jar.media.service.TeacherInfoService;
import com.jz.jar.media.service.TomatoCoursePackService;
import com.jz.jar.media.service.UserCourseService;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;

@Lazy
@Service
public class TomatoCoursePackProxy {

	@Autowired
	private TomatoCoursePackService tomatoCoursePackService;
	@Autowired
	private UserCourseService userCourseService;
	@Autowired
	private TeacherInfoService teacherInfoService;

	public List<TomatoCoursePackWrapper> mutiGetSimplePack(TomatoCoursePackRequest request) {
		if (ArrayMapTools.isEmpty(request.getPids())) {
			return null;
		}
		List<TomatoCoursePack> packs = tomatoCoursePackService.mutiGetOnlinePack(request.getPids(), request.getBrand());

		Map<String, Integer> finishMap = null;
		if (request.isWithFinishCnt() && StringUtils.isNotEmpty(request.getSuid())) {
			finishMap = userCourseService.mutiCalFinishCnt(request.getSuid(), request.getBrand(), request.getPids());
		}

		Set<String> teacherIds = Sets.newHashSet();
		for (TomatoCoursePack p : packs) {
			if (StringUtils.isNotEmpty(p.getTeacher1())) {
				teacherIds.add(p.getTeacher1());
			}
			if (StringUtils.isNotEmpty(p.getTeacher2())) {
				teacherIds.add(p.getTeacher2());
			}
		}
		Map<String, TeacherInfoWrapper> teacherMap = null;
		if (teacherIds.size() > 0) {
			teacherMap = teacherInfoService.mutiGetSimpleTeachers(teacherIds).stream()
					.collect(Collectors.toMap(t -> t.getId(), t -> TeacherInfoWrapper.of(t)));
		}

		List<TomatoCoursePackWrapper> wrappers = Lists.newArrayList();
		for (TomatoCoursePack p : packs) {
			TomatoCoursePackWrapper wrapper = TomatoCoursePackWrapper.ofSimple(p); // 这里以后肯定会拓展，先这样写
			if (request.isWithFinishCnt()) {
				int finishCnt = MapUtils.getIntValue(finishMap, p.getPid());
				if (finishCnt >= p.getVideoCnt()) {
					finishCnt = -1;
				}
				wrapper.setFinishCnt(finishCnt);
			}
			if (StringUtils.isNotEmpty(p.getTeacher1()) && teacherMap != null) {
				wrapper.setTeacher1(teacherMap.get(p.getTeacher1()));
			}
			if (StringUtils.isNotEmpty(p.getTeacher2()) && teacherMap != null) {
				wrapper.setTeacher2(teacherMap.get(p.getTeacher2()));
			}
			wrappers.add(wrapper);
		}
		if (request.isKeepOrder()) {
			// 注意这里可能会造成数据重复
			return OrderTool.keepOrder(request.getPids(), wrappers, TomatoCoursePackWrapper::getPid);
		} else {
			return wrappers;
		}
	}

	public Map<String, TomatoCoursePackWrapper> mutiGetSimplePackMap(TomatoCoursePackRequest request) {
		// 返回map的话，就没有排序的意义了
		request.setKeepOrder(false);
		List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
		if (wrappers == null) {
			return null;
		}
		return wrappers.stream().collect(Collectors.toMap(p -> p.getPid(), p -> p));
	}

	public List<ItemCard> mutiGetPackCards(TomatoCoursePackRequest request) {
		List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
		if (wrappers == null) {
			return null;
		}
		return wrappers.stream().map(ItemCard::of).collect(Collectors.toList());
	}

	public Map<String, ItemCard> mutiGetPackCardMap(TomatoCoursePackRequest request) {
		request.setKeepOrder(false);
		List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
		if (wrappers == null) {
			return null;
		}
		return wrappers.stream().collect(Collectors.toMap(p -> p.getPid(), p -> ItemCard.of(p)));
	}

}