/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.tool;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.enums.PictureCompress;
import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.pojos.UploadVideo;

public class VideoTool {
    private static String getSnapshotName(int cnt) {
        return (cnt < 10 ? "0000" : "000") + cnt;
    }

    public static void getUploadVideoDefault(VideoWrapper wrapper) {
        wrapper.setSnapshotUrl(AliyunBean.getImagesUrl("playabc/sys/upload_video.png", null));
    }

    private static void getSnapshotUrl(VideoWrapper wrapper, String snapshotUrl, Integer cnt, PictureCompress compress) {
        if (StringTools.isEmptyAndBlank((String)snapshotUrl)) {
            return;
        }
        cnt = null == cnt || cnt <= 0 ? 1 : cnt;
        String tempUrl = snapshotUrl.replace("{Count}", VideoTool.getSnapshotName(cnt));
        wrapper.setSnapshotUrl(AliyunBean.getImagesUrl(tempUrl, compress));
    }

    public static void getSnapshotUrl(String uid, UploadVideo video, VideoWrapper wrapper) {
        int cnt = 1;
        if (StringTools.isNotEmptyAndBlank((String)uid) && null != video.getSnapshotCnt()) {
            cnt = Math.abs(uid.hashCode()) % video.getSnapshotCnt();
        }
        VideoTool.getSnapshotUrl(wrapper, video.getSnapshotUrl(), cnt, PictureCompress._30);
    }

    public static void getSnapshotUrl(String uid, MediaVideo video, VideoWrapper wrapper) {
        if (null != video.getSelectedSnapshot()) {
            wrapper.setSnapshotUrl(AliyunBean.getImagesUrl(video.getSelectedSnapshot(), PictureCompress._60));
            return;
        }
        int cnt = 1;
        if (StringTools.isNotEmptyAndBlank((String)uid)) {
            cnt = Math.abs(uid.hashCode()) % video.getSnapshotCnt();
        }
        VideoTool.getSnapshotUrl(wrapper, video.getSnapshotUrl(), cnt, PictureCompress._60);
    }

    public static void getVideoUrl(MediaVideo video, VideoWrapper wrapper) {
        VideoTool.getVideoUrl(wrapper, video.getHd(), video.getNormal(), video.getLow(), video.getAudit());
    }

    public static void getVideoUrl(UploadVideo video, VideoWrapper wrapper) {
        VideoTool.getVideoUrl(wrapper, video.getHd(), video.getNormal(), video.getLow(), video.getAudit());
    }

    private static void getVideoUrl(VideoWrapper wrapper, String hd, String normal, String low, String audit) {
        int expireSeconds = 3600;
        wrapper.setHd(AliyunBean.getMediaCdnAuthUrl(hd, expireSeconds));
        wrapper.setNormal(AliyunBean.getMediaCdnAuthUrl(normal, expireSeconds));
        wrapper.setLow(AliyunBean.getMediaCdnAuthUrl(low, expireSeconds));
        wrapper.setAudit(AliyunBean.getImagesUrl(audit));
    }
}

