/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.proxy.common.PlaylistProxy;
import com.jz.jar.business.request.ImgTxtRequest;
import com.jz.jar.business.request.PlaylistRequest;
import com.jz.jar.business.wrapper.WImageText;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.TomatoImageTextService;
import com.jz.jar.media.service.UserCollectImageTextService;
import com.jz.jooq.media.tables.pojos.TomatoImageText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Lazy
@Service
public class ImageTxtProxy {
    @Autowired
    private TomatoImageTextService tomatoImageTextService;
    @Autowired
    private PlaylistService playlistService;
    @Autowired
    private PlaylistProxy playlistProxy;
    @Autowired
    private UserCollectImageTextService userCollectImageTextService;
    private static final Random random = new Random();

    public WImageText getImageTextInfo(ImgTxtRequest request, BrandEnum brand) {
        TomatoImageText imageText = this.tomatoImageTextService.getOnlineImageText(request.getIid());
        if (null == imageText) {
            return null;
        }
        WImageText wp = WImageText.of(imageText, request.getPid()).setIsCollect(false);
        PlaylistRequest playlistRequest = PlaylistRequest.of(request.getUid(), request.getPid());
        wp.setPlaylist(this.playlistProxy.getSinglePlaylist(playlistRequest, brand));
        wp.setCollectCnt(this.userCollectImageTextService.countCollect(imageText.getId()));
        wp.setPic(AliyunBean.getImagesUrl(imageText.getPic()));
        if (StringTools.isNotEmpty((CharSequence)request.getUid()) && request.getIsWithCollect().booleanValue()) {
            wp.setIsCollect(this.userCollectImageTextService.isCollect(request.getUid(), request.getIid()));
        }
        return wp;
    }

    public List<WImageText> getImageTextWps(ImgTxtRequest request, BrandEnum brand) {
        List tmp;
        List its = this.tomatoImageTextService.findOnlineImageText(request.getIids());
        if (ArrayMapTools.isEmpty((Collection)its)) {
            return null;
        }
        Map iid2Cnt = this.userCollectImageTextService.countCollect(request.getIids());
        ArrayList ciids = Lists.newArrayList();
        if (StringTools.isNotEmpty((CharSequence)request.getUid()) && request.getIsWithCollect().booleanValue() && null != (tmp = this.userCollectImageTextService.filterCollectForUser(request.getUid(), request.getIids()))) {
            ciids.addAll(tmp);
        }
        ArrayList wps = Lists.newArrayList();
        for (TomatoImageText tit : its) {
            WImageText imageText = WImageText.of(tit, request.getPid());
            imageText.setCollectCnt(MapUtils.getInteger((Map)iid2Cnt, (Object)tit.getId(), (Integer)0));
            imageText.setPic(AliyunBean.getImagesUrl(tit.getPic()));
            imageText.setIsCollect(ciids.contains(tit.getId()));
            wps.add(imageText);
        }
        return OrderTool.keepOrder(request.getIids(), (Collection)wps, WImageText::getIid);
    }

    public Map<String, WImageText> getImageTxtWpHas(ImgTxtRequest request, BrandEnum brand) {
        List<WImageText> wps = this.getImageTextWps(request, brand);
        if (ArrayMapTools.isEmpty(wps)) {
            return Maps.newHashMap();
        }
        LinkedHashMap iid2Wp = Maps.newLinkedHashMap();
        wps.forEach(it -> iid2Wp.put(it.getIid(), it));
        return iid2Wp;
    }

    public List<ItemCard> getImageTextCards(ImgTxtRequest request, BrandEnum brand) {
        List<WImageText> its = this.getImageTextWps(request, brand);
        if (ArrayMapTools.isEmpty(its)) {
            return null;
        }
        return its.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public Map<String, ItemCard> getImageTxtCardHas(ImgTxtRequest request, BrandEnum brand) {
        List<ItemCard> cards = this.getImageTextCards(request, brand);
        if (ArrayMapTools.isEmpty(cards)) {
            return Maps.newHashMap();
        }
        LinkedHashMap iid2Card = Maps.newLinkedHashMap();
        cards.forEach(it -> iid2Card.put(it.getImgTxt().getIid(), it));
        return iid2Card;
    }

    @Transactional
    public void addImageTextWatchCnt(BrandEnum brand, String iid, String pid) {
        int randomWatchCnt = random.nextInt(200);
        this.tomatoImageTextService.addWatchCnt(iid, randomWatchCnt);
        this.playlistService.addWatchCnt(pid, brand, randomWatchCnt);
    }
}

