package com.jz.jar.business.wrapper;

import com.jz.jooq.franchise.tables.pojos.Lesson;

public class LessonFeedbackWrapper extends WPBFeedback {
	private LessonFeedbackWrapper() {
	}

	private String schoolId;
	private String lessonId;
	private String lessonTitle;
	// 第几节
	private Integer lessonTimes;

	// 是否已请假
	private Boolean isLeave;

	public static LessonFeedbackWrapper of(Lesson lesson) {
		return new LessonFeedbackWrapper().setSchoolId(lesson.getSchoolId()).setLessonId(lesson.getLessonId())
				.setLessonTimes(lesson.getLessonTime());
	}

	public String getSchoolId() {
		return schoolId;
	}

	public LessonFeedbackWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getLessonId() {
		return lessonId;
	}

	public LessonFeedbackWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public LessonFeedbackWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public Integer getLessonTimes() {
		return lessonTimes;
	}

	public LessonFeedbackWrapper setLessonTimes(Integer lessonTimes) {
		this.lessonTimes = lessonTimes;
		return this;
	}

	public Boolean getIsLeave() {
		return isLeave;
	}

	public LessonFeedbackWrapper setIsLeave(Boolean isLeave) {
		this.isLeave = isLeave;
		return this;
	}

}
