package com.jz.jar.business.bean;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.jz.jar.business.wrapper.WechatOffiaccount;
import com.jz.jar.media.enums.BrandEnum;

/**
 * @Title WechatOffiaccountGlobal
 * @Package com.jz.jar.business.bean
 * @author tangjunfeng
 * @date 2019年11月1日 上午10:57:13
 * @version V1.0
 */
@Component
public class WechatOffiaccountGlobal {

	private static WechatOffiaccountGlobal _this;

	public WechatOffiaccountGlobal() {
		_this = this;
	}

	@Value("${tomato.wechat.official.account.appid}")
	private String wechatAppid;
	@Value("${tomato.wechat.official.account.secret}")
	private String wechatSecret;

	/** 获取微信公众号账户信息 */
	public static WechatOffiaccount getWechatOffiaccount(BrandEnum brand) {
		if (BrandEnum.tomato == brand) {
			// 蕃茄田艺术会员服务，登录邮箱：leona.dong@tomatoart.com.cn
			return WechatOffiaccount.of(_this.wechatAppid, _this.wechatSecret);
		}
		// 精中教育，登录邮箱：3104332437@qq.com
		return WechatOffiaccount.of("wx6ed1b359741332d8", "f0baaccdf1f7893e712e49b8d8a16544");
	}
}
