package com.jz.jar.business.wrapper;

import java.util.Map;

import com.jz.common.utils.other.ConstantsTool;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.tables.pojos.Playlist;

/**
 * @Title PlaylistWrapper
 * @Package com.jz.playabc.api.wrapper
 * @author tangjunfeng
 * @date 2018年8月2日 下午12:17:11
 * @version V1.0
 */
public class PlaylistWrapper {
	private PlaylistWrapper() {
	}

	private String pid;
	private String name;
	private String type;
	private String pic;
	private Map<String, String> pics;
	private Integer videoCnt;
	private Integer watchCnt;
	private Integer difficulty;
	private String target;
	private String remarks;
	private Long lastUpdate;
	private Boolean isCourseware;
	private Boolean isMustHaveContract;
	// topic.id
	private String cid;

	private VideoWrapper video;
	// 收藏数
	private Integer collectCnt;
	// 完成百分比
	private Integer completePercent;
	// 是否收藏
	private Boolean isCollect;
	// 是否推荐
	private Boolean isRecomm;
	// 是否已完成
	private Boolean isComplete;

	public static PlaylistWrapper of(Playlist playlist) {
		PlaylistWrapper wrapper = new PlaylistWrapper().setPid(playlist.getPid()).setName(playlist.getName())
				.setType(playlist.getType()).setVideoCnt(playlist.getVideoCnt()).setWatchCnt(playlist.getWatchCnt())
				.setRemarks(playlist.getRemarks()).setLastUpdate(playlist.getLastUpdate());
		if (BrandEnum.playabc.name().equals(playlist.getBrand())) {
			wrapper.setDifficulty(playlist.getDifficulty()).setTarget(playlist.getTarget()).setIsCourseware(
					null != playlist.getIsCourseware() && playlist.getIsCourseware() == ConstantsTool._1byte);
		}
		return wrapper;
	}

	public String getPid() {
		return pid;
	}

	public PlaylistWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getName() {
		return name;
	}

	public PlaylistWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getType() {
		return type;
	}

	public PlaylistWrapper setType(String type) {
		this.type = type;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public PlaylistWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public Map<String, String> getPics() {
		return pics;
	}

	public PlaylistWrapper setPics(Map<String, String> pics) {
		this.pics = pics;
		return this;
	}

	public Integer getVideoCnt() {
		return videoCnt;
	}

	public PlaylistWrapper setVideoCnt(Integer videoCnt) {
		this.videoCnt = videoCnt;
		return this;
	}

	public Integer getWatchCnt() {
		return watchCnt;
	}

	public PlaylistWrapper setWatchCnt(Integer watchCnt) {
		this.watchCnt = watchCnt;
		return this;
	}

	public Integer getDifficulty() {
		return difficulty;
	}

	public PlaylistWrapper setDifficulty(Integer difficulty) {
		this.difficulty = difficulty;
		return this;
	}

	public String getTarget() {
		return target;
	}

	public PlaylistWrapper setTarget(String target) {
		this.target = target;
		return this;
	}

	public String getRemarks() {
		return remarks;
	}

	public PlaylistWrapper setRemarks(String remarks) {
		this.remarks = remarks;
		return this;
	}

	public Long getLastUpdate() {
		return lastUpdate;
	}

	public PlaylistWrapper setLastUpdate(Long lastUpdate) {
		this.lastUpdate = lastUpdate;
		return this;
	}

	public Boolean getIsCourseware() {
		return isCourseware;
	}

	public PlaylistWrapper setIsCourseware(Boolean isCourseware) {
		this.isCourseware = isCourseware;
		return this;
	}

	public Boolean getIsMustHaveContract() {
		return isMustHaveContract;
	}

	public PlaylistWrapper setIsMustHaveContract(Boolean isMustHaveContract) {
		this.isMustHaveContract = isMustHaveContract;
		return this;
	}

	public String getCid() {
		return cid;
	}

	public PlaylistWrapper setCid(String cid) {
		this.cid = cid;
		return this;
	}

	public VideoWrapper getVideo() {
		return video;
	}

	public PlaylistWrapper setVideo(VideoWrapper video) {
		this.video = video;
		return this;
	}

	public Integer getCompletePercent() {
		return completePercent;
	}

	public PlaylistWrapper setCompletePercent(Integer completePercent) {
		this.completePercent = completePercent;
		return this;
	}

	public Integer getCollectCnt() {
		return collectCnt;
	}

	public PlaylistWrapper setCollectCnt(Integer collectCnt) {
		this.collectCnt = collectCnt;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public PlaylistWrapper setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	public Boolean getIsRecomm() {
		return isRecomm;
	}

	public PlaylistWrapper setIsRecomm(Boolean isRecomm) {
		this.isRecomm = isRecomm;
		return this;
	}

	public Boolean getIsComplete() {
		return isComplete;
	}

	public PlaylistWrapper setIsComplete(Boolean isComplete) {
		this.isComplete = isComplete;
		return this;
	}

}
