package com.jz.jar.business.wrapper;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.jooq.media.tables.pojos.WorksInfo;

public class WorksInfoWrapper {
	private WorksInfoWrapper() {
	}

	private String id;
	private String title;
	private String material; // 材料
	private String appraise; // 评价
	private Boolean isOpen; // 是否公开
	private Long createTime;

	private String pic; // 封面图
	private List<String> pictures; // 图片集

	private UserWrapper user;
	private StudentWrapper student;

	private WWorkTopicTheme theme; // 作品专题

	private Integer likeCnt;
	private Boolean isLike; // 当前用户是否已经喜欢
	private String lessonTitle; // 课程名称
	private String courseName; // 课阶名称
	private Long lessonStartTime;
	private Long lessonEndTime;
	private TeacherWrapper teacher;

	private String schoolId;
	private String lessonId;

	public static WorksInfoWrapper of(WorksInfo worksInfo) {
		return new WorksInfoWrapper().setId(worksInfo.getId()).setTitle(worksInfo.getTitle())
				.setMaterial(worksInfo.getMaterial()).setAppraise(worksInfo.getAppraise())
				.setIsOpen(worksInfo.getIsOpen()).setCreateTime(worksInfo.getCreateTime())
				.setSchoolId(worksInfo.getSchoolId()).setLessonId(worksInfo.getLessonId());
	}

	public String getId() {
		return id;
	}

	public WorksInfoWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public WorksInfoWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getMaterial() {
		return material;
	}

	public WorksInfoWrapper setMaterial(String material) {
		this.material = material;
		return this;
	}

	public String getAppraise() {
		return appraise;
	}

	public WorksInfoWrapper setAppraise(String appraise) {
		this.appraise = appraise;
		return this;
	}

	public Boolean getIsOpen() {
		return isOpen;
	}

	public WorksInfoWrapper setIsOpen(Integer isOpen) {
		if (null == isOpen)
			return this;
		this.isOpen = isOpen > 0;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public WorksInfoWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public List<String> getPictures() {
		return pictures;
	}

	public WorksInfoWrapper setPictures(List<String> pictures) {
		this.pictures = pictures;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public WorksInfoWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public UserWrapper getUser() {
		return user;
	}

	public WorksInfoWrapper setUser(UserWrapper user) {
		this.user = user;
		return this;
	}

	public StudentWrapper getStudent() {
		return student;
	}

	public WorksInfoWrapper setStudent(StudentWrapper student) {
		this.student = student;
		return this;
	}

	public WWorkTopicTheme getTheme() {
		return theme;
	}

	public WorksInfoWrapper setTheme(WWorkTopicTheme theme) {
		this.theme = theme;
		return this;
	}

	public Boolean getIsLike() {
		return isLike;
	}

	public WorksInfoWrapper setIsLike(Boolean isLike) {
		this.isLike = isLike;
		return this;
	}

	public Integer getLikeCnt() {
		return likeCnt;
	}

	public WorksInfoWrapper setLikeCnt(Integer likeCnt) {
		this.likeCnt = likeCnt;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public WorksInfoWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public String getCourseName() {
		return courseName;
	}

	public WorksInfoWrapper setCourseName(String courseName) {
		this.courseName = courseName;
		return this;
	}

	public Long getLessonStartTime() {
		return lessonStartTime;
	}

	public WorksInfoWrapper setLessonStartTime(Long lessonStartTime) {
		this.lessonStartTime = lessonStartTime;
		return this;
	}

	public Long getLessonEndTime() {
		return lessonEndTime;
	}

	public WorksInfoWrapper setLessonEndTime(Long lessonEndTime) {
		this.lessonEndTime = lessonEndTime;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public WorksInfoWrapper setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	@JsonIgnore
	public String getSchoolId() {
		return schoolId;
	}

	public WorksInfoWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	@JsonIgnore
	public String getLessonId() {
		return lessonId;
	}

	public WorksInfoWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

}
