package com.jz.aliyun.callback;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.MethodNotSupportedException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.jz.common.utils.text.StringTools;

public class MtsCallback {

	private static final Logger logger = LoggerFactory.getLogger(MtsCallback.class);

	/** 是否来自aliyun mts */
	public static boolean authenticate(HttpServletRequest request) throws MethodNotSupportedException {
		// 提取header
		Map<String, String> headers = Maps.newHashMap();
		Enumeration<String> headerNames = request.getHeaderNames();
		while (headerNames.hasMoreElements()) {
			String name = headerNames.nextElement();
			headers.put(name, request.getHeader(name));
		}
		logger.info("transCodeCallback.headers : {}", headers);
		if (!headers.containsKey("x-mns-signing-cert-url")) {
			logger.error("not found cert url");
			return false;
		}
		String certUrl = new String(Base64.decodeBase64(headers.get("x-mns-signing-cert-url")));
		String method = request.getMethod().toUpperCase(Locale.ENGLISH);
		if (!StringTools.contains(method, "GET", "HEAD", "POST"))
			throw new MethodNotSupportedException(method + " method not supported");
		if (MtsCallback.authenticate(method, request.getRequestURI(), headers, certUrl))
			return true;
		logger.error("authenticate fail");
		return false;
	}

	private static boolean authenticate(String method, String uri, Map<String, String> headers, String cert) {
		String str2sign = getSignStr(method, uri, headers);
		String signature = headers.get("authorization");
		byte[] decodedSign = Base64.decodeBase64(signature);
		// get cert, and verify this request with this cert
		try {
			URL url = new URL(cert);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			DataInputStream in = new DataInputStream(conn.getInputStream());
			CertificateFactory cf = CertificateFactory.getInstance("X.509");

			Certificate c = cf.generateCertificate(in);
			PublicKey pk = c.getPublicKey();

			java.security.Signature signetcheck = java.security.Signature.getInstance("SHA1withRSA");
			signetcheck.initVerify(pk);
			signetcheck.update(str2sign.getBytes());
			return signetcheck.verify(decodedSign);
		} catch (Exception e) {
			logger.error("authenticate fail, " + e.getMessage(), e);
			return false;
		}
	}

	private static String getSignStr(String method, String uri, Map<String, String> headers) {
		StringBuilder sb = new StringBuilder().append(method).append("\n");
		sb.append(StringTools.ternary(headers.get("content-md5"))).append("\n");
		sb.append(StringTools.ternary(headers.get("content-type"))).append("\n");
		sb.append(StringTools.ternary(headers.get("date"))).append("\n");

		List<String> xmnsArray = Lists.newArrayList();
		for (Map.Entry<String, String> entry : headers.entrySet()) {
			if (entry.getKey().startsWith("x-mns-"))
				xmnsArray.add(entry.getKey() + ":" + entry.getValue());
		}
		Collections.sort(xmnsArray);
		xmnsArray.forEach(kv -> sb.append(kv).append("\n"));
		sb.append(uri);
		return sb.toString();
	}
	
	public static String getMessage(HttpServletRequest request)
			throws UnsupportedEncodingException, IOException, DocumentException {
		// 提取body信息
		String body = CharStreams.toString(new InputStreamReader(request.getInputStream(), "UTF-8"));
		logger.info("transCodeCallback.body : {}", body);
		if (StringTools.isEmptyAndBlank(body))
			throw new NullPointerException();
		SAXReader saxReader = new SAXReader();
		Document document = saxReader.read(new ByteArrayInputStream(body.getBytes("UTF-8")));
		Element root = document.getRootElement();
		return root.element("Message").getTextTrim();
	}
}