/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.google.common.collect.Maps;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.AliyunNewSignTool;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class MtsTools {
    private static final String mtsDomain = "https://mts-vpc.cn-beijing.aliyuncs.com";
    private static String ossLocation = "oss-cn-beijing";
    private AliyunConfig aliyunConfig;

    private MtsTools(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    public static MtsTools of(AliyunConfig aliyunConfig) {
        return new MtsTools(aliyunConfig);
    }

    private Map<String, String> getDefaultArguments(String action) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("AccessKeyId", this.aliyunConfig.getAccessKeyId());
        arguments.put("Format", "JSON");
        arguments.put("Version", "2014-06-18");
        arguments.put("SignatureMethod", "HMAC-SHA1");
        arguments.put("SignatureVersion", "1.0");
        arguments.put("SignatureNonce", StringTools.RandomString.random((int)64));
        arguments.put("Timestamp", AliyunNewSignTool.getFormatIso8601Date());
        arguments.put("Action", action);
        return arguments;
    }

    private String getHttpPostResponse(Map<String, String> arguments) throws Exception {
        String sign = AliyunNewSignTool.generateSign("POST", arguments, this.aliyunConfig.getAccessKeySecret());
        arguments.put("Signature", sign);
        return ConnectPost.send((String)mtsDomain, arguments, (String)"UTF-8");
    }

    public String submitAnalysis(String ossInputObject, String pipelineId) throws Exception {
        Map<String, String> arguments = this.getDefaultArguments("SubmitAnalysisJob");
        HashMap input = Maps.newHashMap();
        input.put("Bucket", this.aliyunConfig.getBucketName());
        input.put("Location", ossLocation);
        input.put("Object", URLEncoder.encode(ossInputObject, "UTF-8"));
        arguments.put("Input", GsonTools.gson.toJson((Object)input));
        arguments.put("PipelineId", pipelineId);
        String result = this.getHttpPostResponse(arguments);
        if (StringTools.isEmpty((CharSequence)result)) {
            return null;
        }
        Map has = (Map)GsonTools.gson.fromJson(result, Map.class);
        if (!has.containsKey("AnalysisJob")) {
            return null;
        }
        Map analysis = MapUtils.getMap((Map)has, (Object)"AnalysisJob");
        if (!analysis.containsKey("Id")) {
            return null;
        }
        return MapUtils.getString((Map)analysis, (Object)"Id");
    }

    public Map<String, String> queryAnalysis(String analysisId) throws Exception {
        Map<String, String> arguments = this.getDefaultArguments("QueryAnalysisJobList");
        arguments.put("AnalysisJobIds", analysisId);
        String result = this.getHttpPostResponse(arguments);
        if (StringTools.isEmpty((CharSequence)result)) {
            return null;
        }
        Map has = (Map)GsonTools.gson.fromJson(result, Map.class);
        if (!has.containsKey("AnalysisJobList")) {
            return null;
        }
        Map AnalysisJobList = MapUtils.getMap((Map)has, (Object)"AnalysisJobList");
        Map AnalysisJob = (Map)((List)AnalysisJobList.get("AnalysisJob")).get(0);
        if (!AnalysisJob.containsKey("TemplateList")) {
            return null;
        }
        Map TemplateList = MapUtils.getMap((Map)AnalysisJob, (Object)"TemplateList");
        List templates = (List)TemplateList.get("Template");
        if (ArrayMapTools.isEmpty((Collection)templates)) {
            return null;
        }
        HashMap templateId2Name = Maps.newHashMap();
        for (Map tmplate : templates) {
            templateId2Name.put(MapUtils.getString((Map)tmplate, (Object)"Id"), MapUtils.getString((Map)tmplate, (Object)"Name"));
        }
        return templateId2Name;
    }

    public String submitTransCode(String inputObject, String outputObject, String templateId, String pipelineId) throws Exception {
        Map<String, String> arguments = this.getDefaultArguments("SubmitJobs");
        HashMap input = Maps.newHashMap();
        input.put("Bucket", this.aliyunConfig.getSourceBucketName());
        input.put("Location", ossLocation);
        input.put("Object", URLEncoder.encode(inputObject, "UTF-8"));
        arguments.put("Input", GsonTools.gson.toJson((Object)input));
        arguments.put("OutputBucket", this.aliyunConfig.getTargetBucketName());
        arguments.put("OutputLocation", ossLocation);
        HashMap output = Maps.newHashMap();
        output.put("OutputObject", URLEncoder.encode(outputObject, "UTF-8"));
        output.put("TemplateId", templateId);
        arguments.put("Outputs", GsonTools.gson.toJson(Arrays.asList(output)));
        arguments.put("PipelineId", pipelineId);
        String result = this.getHttpPostResponse(arguments);
        if (StringTools.isEmpty((CharSequence)result)) {
            return null;
        }
        Map has = (Map)GsonTools.gson.fromJson(result, Map.class);
        if (!has.containsKey("JobResultList")) {
            return null;
        }
        Map JobResultList = MapUtils.getMap((Map)has, (Object)"JobResultList");
        Map JobResult = (Map)((List)JobResultList.get("JobResult")).get(0);
        if (!ArrayMapTools.containsKeys((Map)JobResult, (String[])new String[]{"Success", "Job"})) {
            return null;
        }
        if (!MapUtils.getBoolean((Map)JobResult, (Object)"Success").booleanValue()) {
            return null;
        }
        return MapUtils.getString((Map)MapUtils.getMap((Map)JobResult, (Object)"Job"), (Object)"JobId");
    }

    public String queryTransCode(String jobId) throws Exception {
        Map<String, String> arguments = this.getDefaultArguments("QueryJobList");
        arguments.put("JobIds", jobId);
        String result = this.getHttpPostResponse(arguments);
        if (StringTools.isEmpty((CharSequence)result)) {
            return null;
        }
        Map has = (Map)GsonTools.gson.fromJson(result, Map.class);
        if (!has.containsKey("JobList")) {
            return null;
        }
        Map JobList = MapUtils.getMap((Map)has, (Object)"JobList");
        Map Job = (Map)((List)JobList.get("Job")).get(0);
        if (!Job.containsKey("State") || !"TranscodeSuccess".equals(Job.get("State"))) {
            return null;
        }
        Map Output = MapUtils.getMap((Map)Job, (Object)"Output");
        if (!Output.containsKey("OutputFile")) {
            return null;
        }
        Map OutputFile = MapUtils.getMap((Map)Output, (Object)"OutputFile");
        String object = MapUtils.getString((Map)OutputFile, (Object)"Object");
        if (StringTools.isEmptyAndBlank((String)object)) {
            return null;
        }
        return URLDecoder.decode(object, "UTF-8");
    }
}

