package com.jz.aliyun.tools;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.google.common.collect.Maps;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;

public class MtsTools {

	private static final String mtsDomain = "https://mts.cn-beijing.aliyuncs.com";
	private static String ossLocation = "oss-cn-beijing";

	private AliyunConfig aliyunConfig;

	private MtsTools(AliyunConfig aliyunConfig) {
		super();
		this.aliyunConfig = aliyunConfig;
	}

	public static MtsTools of(AliyunConfig aliyunConfig) {
		return new MtsTools(aliyunConfig);
	}

	/** 获取公共参数 */
	private Map<String, String> getDefaultArguments(String action) {
		Map<String, String> arguments = new HashMap<String, String>();
		arguments.put("AccessKeyId", aliyunConfig.getAccessKeyId());
		arguments.put("Format", "JSON");
		arguments.put("Version", "2014-06-18");
		arguments.put("SignatureMethod", "HMAC-SHA1");
		arguments.put("SignatureVersion", "1.0");
		arguments.put("SignatureNonce", StringTools.RandomString.random(64));
		arguments.put("Timestamp", AliyunNewSignTool.getFormatIso8601Date());
		arguments.put("Action", action);
		return arguments;
	}

	/** 签名 & 发送POST请求 */
	private String getHttpPostResponse(Map<String, String> arguments) throws Exception {
		String sign = AliyunNewSignTool.generateSign("POST", arguments, aliyunConfig.getAccessKeySecret());
		arguments.put("Signature", sign);
		return ConnectPost.send(mtsDomain, arguments, AliyunNewSignTool.CHARSET_UTF8);
	}

	/** 提交转码分析<br/> @return 分析任务ID */
	@SuppressWarnings("unchecked")
	public String submitAnalysis(String ossInputObject, String pipelineId) throws Exception {
		Map<String, String> arguments = getDefaultArguments("SubmitAnalysisJob");

		Map<String, String> input = Maps.newHashMap();
		input.put("Bucket", aliyunConfig.getBucketName());
		input.put("Location", ossLocation);
		input.put("Object", URLEncoder.encode(ossInputObject, AliyunNewSignTool.CHARSET_UTF8));
		arguments.put("Input", GsonTools.gson.toJson(input));
		// 通知管道
		arguments.put("PipelineId", pipelineId);

		String result = this.getHttpPostResponse(arguments);
		if (StringTools.isEmpty(result))
			return null;
		Map<String, Object> has = GsonTools.gson.fromJson(result, Map.class);
		if (!has.containsKey("AnalysisJob"))
			return null;
		Map<String, Object> analysis = MapUtils.getMap(has, "AnalysisJob");
		if (!analysis.containsKey("Id"))
			return null;
		return MapUtils.getString(analysis, "Id");
	}

	/** 查询分析结果<br/> @return 可转码的模板ID */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Map<String, String> queryAnalysis(String analysisId) throws Exception {
		Map<String, String> arguments = getDefaultArguments("QueryAnalysisJobList");
		arguments.put("AnalysisJobIds", analysisId);
		String result = this.getHttpPostResponse(arguments);
		if (StringTools.isEmpty(result))
			return null;
		Map<String, Object> has = GsonTools.gson.fromJson(result, Map.class);
		if (!has.containsKey("AnalysisJobList"))
			return null;
		Map AnalysisJobList = MapUtils.getMap(has, "AnalysisJobList");
		Map AnalysisJob = (Map) ((List) AnalysisJobList.get("AnalysisJob")).get(0);
		if (!AnalysisJob.containsKey("TemplateList"))
			return null;
		Map TemplateList = MapUtils.getMap(AnalysisJob, "TemplateList");
		List<Map> templates = (List<Map>) TemplateList.get("Template");
		if (ArrayMapTools.isEmpty(templates))
			return null;
		Map<String, String> templateId2Name = Maps.newHashMap();
		for (Map tmplate : templates) {
			templateId2Name.put(MapUtils.getString(tmplate, "Id"), MapUtils.getString(tmplate, "Name"));
		}
		return templateId2Name;
	}

	/** 提交转码任务<br/> @return 转码任务ID */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public String submitTransCode(String inputObject, String outputObject, String templateId, String pipelineId)
			throws Exception {
		Map<String, String> arguments = getDefaultArguments("SubmitJobs");

		// 输入内容
		Map<String, String> input = Maps.newHashMap();
		input.put("Bucket", aliyunConfig.getSourceBucketName());
		input.put("Location", ossLocation);
		input.put("Object", URLEncoder.encode(inputObject, AliyunNewSignTool.CHARSET_UTF8));
		arguments.put("Input", GsonTools.gson.toJson(input));

		// 输出bucket
		arguments.put("OutputBucket", aliyunConfig.getTargetBucketName());
		arguments.put("OutputLocation", ossLocation);

		// 输出内容
		Map<String, String> output = Maps.newHashMap();
		output.put("OutputObject", URLEncoder.encode(outputObject, AliyunNewSignTool.CHARSET_UTF8));
		// 转码模板ID
		output.put("TemplateId", templateId);
		arguments.put("Outputs", GsonTools.gson.toJson(Arrays.asList(output)));

		// 通知管道
		arguments.put("PipelineId", pipelineId);

		String result = this.getHttpPostResponse(arguments);
		if (StringTools.isEmpty(result))
			return null;
		Map<String, Object> has = GsonTools.gson.fromJson(result, Map.class);
		if (!has.containsKey("JobResultList"))
			return null;
		Map JobResultList = MapUtils.getMap(has, "JobResultList");
		Map JobResult = (Map) ((List) JobResultList.get("JobResult")).get(0);
		if (!ArrayMapTools.containsKeys(JobResult, "Success", "Job"))
			return null;
		if (!MapUtils.getBoolean(JobResult, "Success"))
			return null;
		return MapUtils.getString(MapUtils.getMap(JobResult, "Job"), "JobId");
	}

	/** 查询转码任务结果<br/> @return 转码后的文件地址 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public String queryTransCode(String jobId) throws Exception {
		Map<String, String> arguments = getDefaultArguments("QueryJobList");
		arguments.put("JobIds", jobId);
		String result = this.getHttpPostResponse(arguments);
		if (StringTools.isEmpty(result))
			return null;
		Map<String, Object> has = GsonTools.gson.fromJson(result, Map.class);
		if (!has.containsKey("JobList"))
			return null;
		Map JobList = MapUtils.getMap(has, "JobList");
		Map Job = (Map) ((List) JobList.get("Job")).get(0);
		if (!Job.containsKey("State") || !"TranscodeSuccess".equals(Job.get("State")))
			return null;
		Map Output = MapUtils.getMap(Job, "Output");
		if (!Output.containsKey("OutputFile"))
			return null;
		Map OutputFile = MapUtils.getMap(Output, "OutputFile");
		String object = MapUtils.getString(OutputFile, "Object");
		if (StringTools.isEmptyAndBlank(object))
			return null;
		return URLDecoder.decode(object, AliyunNewSignTool.CHARSET_UTF8);
	}
}