package com.jz.aliyun.tools;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.google.common.collect.Maps;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;

public class MtsTools {

	private static final String mtsDomain = "https://mts.cn-beijing.aliyuncs.com";
	private static String ossLocation = "oss-cn-beijing";

	private AliyunConfig aliyunConfig;

	private MtsTools(AliyunConfig aliyunConfig) {
		super();
		this.aliyunConfig = aliyunConfig;
	}

	public static MtsTools of(AliyunConfig aliyunConfig) {
		return new MtsTools(aliyunConfig);
	}

	/** 获取公共参数 */
	private Map<String, String> getDefaultArguments(String action) {
		Map<String, String> arguments = new HashMap<String, String>();
		arguments.put("AccessKeyId", aliyunConfig.getAccessKeyId());
		arguments.put("Format", "JSON");
		arguments.put("Version", "2014-06-18");
		arguments.put("SignatureMethod", "HMAC-SHA1");
		arguments.put("SignatureVersion", "1.0");
		arguments.put("SignatureNonce", StringTools.RandomString.random(64));
		arguments.put("Timestamp", AliyunNewSignTool.getFormatIso8601Date());
		arguments.put("Action", action);
		return arguments;
	}

	/** 签名 & 发送POST请求 */
	private String getHttpPostResponse(Map<String, String> arguments) throws Exception {
		String sign = AliyunNewSignTool.generateSign("POST", arguments, aliyunConfig.getAccessKeySecret());
		arguments.put("Signature", sign);
		return ConnectPost.send(mtsDomain, arguments, AliyunNewSignTool.CHARSET_UTF8);
	}

	@SuppressWarnings("unchecked")
	public String submitAnalysis(String ossInputObject, String pipelineId) throws Exception {
		Map<String, String> arguments = getDefaultArguments("SubmitAnalysisJob");

		Map<String, String> input = Maps.newHashMap();
		input.put("Bucket", aliyunConfig.getBucketName());
		input.put("Location", ossLocation);
		input.put("Object", ossInputObject);
		arguments.put("Input", GsonTools.gson.toJson(input));
		// 通知管道
		arguments.put("PipelineId", pipelineId);

		String result = this.getHttpPostResponse(arguments);
		if (StringTools.isEmpty(result))
			return null;
		Map<String, Object> has = GsonTools.gson.fromJson(result, Map.class);
		if (!has.containsKey("AnalysisJob"))
			return null;
		Map<String, Object> analysis = GsonTools.gson.fromJson(MapUtils.getString(has, "AnalysisJob"), Map.class);
		if (!analysis.containsKey("Id"))
			return null;
		return MapUtils.getString(analysis, "Id");
	}

	@SuppressWarnings("unchecked")
	public boolean queryAnalysis(String analysisId) throws Exception {
		Map<String, String> arguments = getDefaultArguments("QueryAnalysisJobList");
		arguments.put("AnalysisJobIds", analysisId);
		String result = this.getHttpPostResponse(arguments);
		if (StringTools.isEmpty(result))
			return false;
		Map<String, String> has = GsonTools.gson.fromJson(result, Map.class);
		has.forEach((k, v) -> System.out.println(k + " : " + v));
		return true;
	}

}