package com.jz.aliyun.beans;

/**
 * @Title AliyunConfig
 * @Package com.jz.aliyun.beans
 * @author tangjunfeng
 * @date 2018年7月11日 上午10:12:54
 * @version V1.0
 */
public class AliyunConfig {

	private String endpoint;
	private String accessKeyId;
	private String accessKeySecret;
	private String bucketName;
	private String sourceBucketName;
	private String targetBucketName;

	private AliyunConfig() {
	}

	public static AliyunConfig of(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
		return new AliyunConfig().setEndpoint(endpoint).setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret)
				.setBucketName(bucketName);
	}

	public static AliyunConfig of(String endpoint, String accessKeyId, String accessKeySecret, String sourceBucketName,
			String targetBucketName) {
		return new AliyunConfig().setEndpoint(endpoint).setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret)
				.setSourceBucketName(sourceBucketName).setTargetBucketName(targetBucketName);
	}

	public String getEndpoint() {
		return endpoint;
	}

	public AliyunConfig setEndpoint(String endpoint) {
		this.endpoint = endpoint;
		return this;
	}

	public String getAccessKeyId() {
		return accessKeyId;
	}

	public AliyunConfig setAccessKeyId(String accessKeyId) {
		this.accessKeyId = accessKeyId;
		return this;
	}

	public String getAccessKeySecret() {
		return accessKeySecret;
	}

	public AliyunConfig setAccessKeySecret(String accessKeySecret) {
		this.accessKeySecret = accessKeySecret;
		return this;
	}

	public String getBucketName() {
		return bucketName;
	}

	public AliyunConfig setBucketName(String bucketName) {
		this.bucketName = bucketName;
		return this;
	}

	public String getSourceBucketName() {
		return sourceBucketName;
	}

	public AliyunConfig setSourceBucketName(String sourceBucketName) {
		this.sourceBucketName = sourceBucketName;
		return this;
	}

	public String getTargetBucketName() {
		return targetBucketName;
	}

	public AliyunConfig setTargetBucketName(String targetBucketName) {
		this.targetBucketName = targetBucketName;
		return this;
	}

}
