/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.jz.aliyun.tools.AliyunNewSignTool;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.util.HashMap;
import java.util.Map;

public class CDNTools {
    public static boolean refreshCdnCache(String accessKeyId, String accessKeySecret, String path) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("AccessKeyId", accessKeyId);
        param.put("Format", "JSON");
        param.put("Version", "2014-11-11");
        param.put("SignatureMethod", "HMAC-SHA1");
        param.put("SignatureVersion", "1.0");
        param.put("SignatureNonce", StringTools.RandomString.random((int)64));
        param.put("Timestamp", AliyunNewSignTool.getFormatIso8601Date());
        param.put("Action", "RefreshObjectCaches");
        param.put("ObjectPath", path);
        param.put("ObjectType", "File");
        param.put("Signature", AliyunNewSignTool.generateSign("POST", param, accessKeySecret));
        String result = ConnectPost.send((String)"https://cdn.aliyuncs.com", param, (String)"UTF-8");
        if (StringTools.isEmpty((CharSequence)result)) {
            return false;
        }
        Map has = (Map)GsonTools.gson.fromJson(result, Map.class);
        return ArrayMapTools.containsKeys((Map)has, (String[])new String[]{"RefreshTaskId", "RequestId"});
    }

    public static void main(String[] args) {
        try {
            CDNTools.refreshCdnCache("LTAIXIOV1fsWtqzM", "aEnYKzdq9wZS5MLrJw6Dj8amkW3XK9", "http://img.gymchina.com/playabc/playlist/home/rkdhp2o8re430meb.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

