/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.beans.StsTokenConfig;
import com.jz.aliyun.beans.StsUploadInfo;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.security.EncryptionTools;
import com.jz.common.utils.text.StringTools;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsTools {
    private static final Logger logger = LoggerFactory.getLogger(StsTools.class);
    private static final String REGION_CN_BEIJING = "cn-beijing";
    private static final String STS_API_VERSION = "2015-04-01";
    private static final String roleArn = "acs:ram::1651426276585947:role/ramonlyupload";
    private AliyunConfig config;

    private StsTools(AliyunConfig config) {
        this.config = config;
    }

    public static StsTools getInstance(AliyunConfig config) {
        return new StsTools(config);
    }

    private String getFileId(String identity, String clientFileName, StsTokenConfig tokenConfig) {
        if (tokenConfig.isUseSourceName()) {
            return clientFileName;
        }
        return StringTools.ternary((String)tokenConfig.getPrefix()) + IdTools.encode((String)(identity + StringTools.RandomString.random((int)10))) + StringTools.ternary((String)tokenConfig.getSuffix());
    }

    private String getCallbackBody(String callbackBody, String host, String fileId, String savePath, String data, String clientFileName) throws UnsupportedEncodingException {
        if (StringTools.isNotEmptyAndBlank((String)host)) {
            callbackBody = callbackBody + "&host=" + host;
        }
        callbackBody = callbackBody + "&fileId=" + fileId + "&path=" + URLEncoder.encode(savePath, "UTF-8") + "&fileName=" + URLEncoder.encode(clientFileName, "UTF-8");
        callbackBody = callbackBody + "&mimeType=${mimeType}&imageInfo.format=${imageInfo.format}&imgHeight=${imageInfo.height}&imgWidth=${imageInfo.width}";
        callbackBody = callbackBody + "&data=" + data;
        return callbackBody;
    }

    public StsUploadInfo getTemporaryUploadToken(String identity, String clientFileName, StsTokenConfig tokenConfig) throws Exception {
        String fileId = this.getFileId(identity, clientFileName, tokenConfig);
        String path = tokenConfig.getSaveDir();
        if (!path.startsWith(tokenConfig.getBasePath())) {
            path = tokenConfig.getBasePath() + "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + fileId + "." + tokenConfig.getExt();
        StsUploadInfo info = StsUploadInfo.of();
        String roleSessionName = EncryptionTools.MD5((String)identity);
        String policy = this.buildPolicy(tokenConfig.getBasePath(), this.config.getBucketName());
        AssumeRoleResponse resp = this.assumeRole(this.config.getAccessKeyId(), this.config.getAccessKeySecret(), roleArn, roleSessionName, policy, ProtocolType.HTTPS, tokenConfig.getTokenExpireSeconds());
        StringBuilder ossHost = new StringBuilder(this.config.getBucketName()).append(".");
        if (tokenConfig.isEnableHttps()) {
            ossHost.append("https://");
        }
        ossHost.append(this.config.getEndpoint());
        info.setAccessKeyId(resp.getCredentials().getAccessKeyId()).setSecret(resp.getCredentials().getAccessKeySecret()).setHost(ossHost.toString()).setKey(path).setSignature(resp.getCredentials().getSecurityToken()).setExpire(System.currentTimeMillis() / 1000L + (long)tokenConfig.getTokenExpireSeconds());
        if (StringTools.isNotEmpty((CharSequence)tokenConfig.getCallback())) {
            String callbackBody = this.getCallbackBody(tokenConfig.getCallbackBody(), tokenConfig.getCdnHost(), fileId, path, tokenConfig.getData(), clientFileName);
            logger.info("set callback {}, {}", (Object)tokenConfig.getCallback(), (Object)callbackBody);
            info.setCallback(this.genCallback(tokenConfig.getCallback(), callbackBody));
        }
        return info;
    }

    public StsUploadInfo getSignUploadTask(String identity, String clientFileName, StsTokenConfig tokenConfig) throws UnsupportedEncodingException {
        OSSClient client = new OSSClient(this.config.getEndpoint(), this.config.getAccessKeyId(), this.config.getAccessKeySecret());
        String ossHost = this.config.getBucketName() + "." + this.config.getEndpoint();
        ossHost = (tokenConfig.isEnableHttps() ? "https://" : "http://") + ossHost;
        long expireEndTime = System.currentTimeMillis() + (long)(tokenConfig.getTokenExpireSeconds() * 1000);
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", tokenConfig.getSaveDir());
        String postPolicy = client.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("UTF-8");
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = client.calculatePostSignature(postPolicy);
        String fileId = this.getFileId(identity, clientFileName, tokenConfig);
        String fileName = fileId + "." + tokenConfig.getExt();
        String savePath = tokenConfig.getSaveDir() + "/" + fileName;
        StsUploadInfo info = StsUploadInfo.of().setAccessKeyId(this.config.getAccessKeyId()).setHost(ossHost).setPolicy(encodedPolicy).setSignature(postSignature).setKey(savePath).setFileName(fileName).setExpire(expireEndTime / 1000L);
        if (StringTools.isNotEmpty((CharSequence)tokenConfig.getCallback())) {
            String callbackBody = this.getCallbackBody(tokenConfig.getCallbackBody(), StringTools.ternary((String)tokenConfig.getCdnHost(), (String)ossHost), fileId, savePath, tokenConfig.getData(), clientFileName);
            logger.info("set callback {}, {}", (Object)tokenConfig.getCallback(), (Object)callbackBody);
            info.setCallback(this.genCallback(tokenConfig.getCallback(), callbackBody));
        }
        return info;
    }

    private String buildPolicy(String basepath, String bucket) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("oss:PutObject");
        actions.add("oss:InitMultipartUpload");
        actions.add("oss:UploadPart");
        actions.add("oss:ListParts");
        actions.add("oss:CompleteMultipartUpload");
        actions.add("oss:DeleteMultipartUpload");
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("acs:oss:*:*:" + bucket);
        if ("/".equals(basepath)) {
            resources.add("acs:oss:*:*:" + bucket + "/*");
        } else {
            resources.add("acs:oss:*:*:" + bucket + "/" + basepath + "/*");
        }
        HashMap<String, Object> statement = new HashMap<String, Object>();
        statement.put("Action", actions);
        statement.put("Resource", resources);
        statement.put("Effect", "Allow");
        HashMap<String, Object> policy = new HashMap<String, Object>();
        policy.put("Statement", Arrays.asList(statement));
        policy.put("Version", "1");
        return GsonTools.gson.toJson(policy);
    }

    private AssumeRoleResponse assumeRole(String accessKeyId, String accessKeySecret, String roleArn, String roleSessionName, String policy, ProtocolType protocolType, long durationSeconds) throws ServerException, ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_CN_BEIJING, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(STS_API_VERSION);
        request.setMethod(MethodType.POST);
        request.setProtocol(protocolType);
        request.setRoleArn(roleArn);
        request.setRoleSessionName(roleSessionName);
        request.setPolicy(policy);
        request.setDurationSeconds(Long.valueOf(durationSeconds));
        return (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
    }

    private String genCallback(String callbackUrl, String callbackBody) throws UnsupportedEncodingException {
        HashMap<String, String> callback = new HashMap<String, String>();
        callback.put("callbackUrl", callbackUrl);
        callback.put("callbackBody", callbackBody);
        callback.put("callbackBodyType", "application/x-www-form-urlencoded");
        return new String(Base64.encodeBase64((byte[])GsonTools.gson.toJson(callback).getBytes()));
    }
}

