package com.gymchina.tiny.swagger;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @Title SwaggerWebMvcConfigruation
 * @Package com.gymchina.tiny.swagger
 * @author tangjunfeng
 * @date 2018年12月28日 下午6:05:35
 * @version V1.0
 */
@Configuration
public class SwaggerWebMvcConfigruation implements WebMvcConfigurer {

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("swagger-ui.html").addResourceLocations("classpath:/META-INF/resources/");
		registry.addResourceHandler("/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");
		WebMvcConfigurer.super.addResourceHandlers(registry);
	}
}
