/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.remote.property.guide;

import com.gymchina.tiny.common.global.TinyCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
public class TinyAutoRemotePropertySourceLoder
implements PropertySourceLocator {
    @Autowired
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();

    public PropertySource<?> locate(Environment environment) {
        if (this.propertySourceLocators.isEmpty()) {
            return null;
        }
        PropertySourceLocator locator = this.getConfigServicePropertySourceLocator();
        if (null == locator) {
            return null;
        }
        PropertySource resultLocate = locator.locate(environment);
        if (null == resultLocate) {
            return null;
        }
        HashMap allProperties = new HashMap();
        CompositePropertySource propertySource = (CompositePropertySource)resultLocate;
        Collection propertySources = propertySource.getPropertySources();
        for (PropertySource properties : propertySources) {
            if (!(properties instanceof MapPropertySource)) continue;
            MapPropertySource propertyMap = (MapPropertySource)properties;
            allProperties.putAll((Map)propertyMap.getSource());
        }
        if (!allProperties.isEmpty()) {
            TinyCommon.properties.clear();
            TinyCommon.properties.putAll(allProperties);
        }
        return null;
    }

    private PropertySourceLocator getConfigServicePropertySourceLocator() {
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            if (!(locator instanceof ConfigServicePropertySourceLocator)) continue;
            return locator;
        }
        return null;
    }
}

