/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.errors;

import com.gymchina.tiny.mvc.errors.HttpServletErrorAttributes;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HttpServletBaseErrorController {
    @Value(value="${http.servlet.error.message.enabled:true}")
    private boolean enabled;
    @Autowired
    private HttpServletErrorAttributes httpServletErrorAttributes;

    @RequestMapping(value={"/400"})
    public String _400(HttpServletRequest request) {
        return this.printErrorMessageEnabled(request, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/404"})
    public String _404() {
        return this.toJson(HttpStatus.NOT_FOUND, new String[0]);
    }

    @RequestMapping(value={"/405"})
    public String _405() {
        return this.toJson(HttpStatus.METHOD_NOT_ALLOWED, new String[0]);
    }

    @RequestMapping(value={"/500"})
    public String _500(HttpServletRequest request) {
        return this.printErrorMessageEnabled(request, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private String toJson(HttpStatus status, String ... msg) {
        if (null != msg && msg.length > 0 && null != msg[0]) {
            return "{\"status\":" + status.value() + ", \"msg\":\"" + msg[0] + "\"}";
        }
        return "{\"status\":" + status.value() + ", \"msg\":\"" + status.getReasonPhrase() + "\"}";
    }

    private String printErrorMessageEnabled(HttpServletRequest request, HttpStatus status) {
        if (!this.enabled) {
            return this.toJson(status, new String[0]);
        }
        String message = this.httpServletErrorAttributes.getErrorMessage(request);
        if (null != message && message.indexOf("\"") >= 0) {
            message = message.replace("\"", "\\\"");
        }
        return this.toJson(status, message);
    }
}

