/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.errors;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@Component
public class HttpServletErrorAttributes {
    public String getErrorMessage(HttpServletRequest request) {
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Throwable error = this.getError((WebRequest)webRequest);
        if (error != null) {
            while (error instanceof ServletException && error.getCause() != null) {
                error = ((ServletException)error).getCause();
            }
            return this.addErrorMessage(error);
        }
        String message = (String)this.getAttribute((RequestAttributes)webRequest, "javax.servlet.error.message");
        if (!StringUtils.isEmpty((Object)message)) {
            return StringUtils.isEmpty((Object)message) ? "No message available" : message;
        }
        return null;
    }

    private String addErrorMessage(Throwable error) {
        BindingResult result = this.extractBindingResult(error);
        if (result == null) {
            return error.getMessage();
        }
        if (result.getErrorCount() > 0) {
            System.out.println("errors : " + result.getAllErrors());
            return "Validation failed for object='" + result.getObjectName() + "'. Error count: " + result.getErrorCount();
        }
        return null;
    }

    private BindingResult extractBindingResult(Throwable error) {
        if (error instanceof BindingResult) {
            return (BindingResult)error;
        }
        if (error instanceof MethodArgumentNotValidException) {
            return ((MethodArgumentNotValidException)error).getBindingResult();
        }
        return null;
    }

    public Throwable getError(WebRequest webRequest) {
        Throwable exception = (Throwable)this.getAttribute((RequestAttributes)webRequest, "org.springframework.boot.web.servlet.error.DefaultErrorAttributes.ERROR");
        if (null != exception) {
            return exception;
        }
        return (Throwable)this.getAttribute((RequestAttributes)webRequest, "javax.servlet.error.exception");
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }
}

