/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.module.singleposter.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.Html;
import android.text.Spanned;
import android.view.View;
import java.io.File;
import java.io.FileNotFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/module/singleposter/utils/PosterUtils;", "", "()V", "Companion", "SinglePoster_release"})
public final class PosterUtils {
    public static final Companion Companion = new Companion(null);

    private PosterUtils() {
        throw (Throwable)new Error("\u4e0d\u80fd\u521d\u59cb\u5316\u8be5\u7c7b");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Lcom/gymchina/module/singleposter/utils/PosterUtils$Companion;", "", "()V", "forHtmlRemoveWhiteSpace", "", "content", "", "insertSystemAlbum", "", "ctx", "Landroid/content/Context;", "file", "Ljava/io/File;", "updateSystemAlbum", "", "viewToBitmap", "Landroid/graphics/Bitmap;", "view", "Landroid/view/View;", "zoomBitmap", "bitmap", "newWidth", "", "SinglePoster_release"})
    public static final class Companion {
        @NotNull
        public final CharSequence forHtmlRemoveWhiteSpace(@NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Spanned spanned = Html.fromHtml((String)content);
            StringBuilder builder = new StringBuilder();
            Spanned spanned2 = spanned;
            for (int i = 0; i < spanned2.length(); ++i) {
                char c = spanned2.charAt(i);
                if (Character.isWhitespace(c)) continue;
                builder.append(c);
            }
            return builder;
        }

        @NotNull
        public final Bitmap viewToBitmap(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(-1);
            view.draw(canvas);
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
            return bitmap2;
        }

        @Nullable
        public final Bitmap zoomBitmap(@NotNull Bitmap bitmap, int newWidth) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            float scaleWidth = (float)newWidth / (float)width;
            matrix.postScale(scaleWidth, scaleWidth);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            if (Intrinsics.areEqual((Object)bitmap, (Object)newBitmap) ^ true && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            return newBitmap;
        }

        public final boolean insertSystemAlbum(@NotNull Context ctx, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            try {
                MediaStore.Images.Media.insertImage((ContentResolver)ctx.getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
                this.updateSystemAlbum(ctx, file);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }

        public final void updateSystemAlbum(@NotNull Context ctx, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            ctx.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

