/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.roundview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Checkable;
import android.widget.RelativeLayout;
import com.gymchina.android.roundview.helper.RoundAttrs;
import com.gymchina.android.roundview.helper.RoundHelper;

public class RoundRelativeLayout
extends RelativeLayout
implements Checkable,
RoundAttrs {
    RoundHelper mRCHelper = new RoundHelper();

    public RoundRelativeLayout(@NonNull Context context) {
        super(context);
        this.mRCHelper.initAttrs(context, null);
    }

    public RoundRelativeLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mRCHelper.initAttrs(context, attrs);
    }

    public RoundRelativeLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mRCHelper.initAttrs(context, attrs);
    }

    @TargetApi(value=21)
    public RoundRelativeLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mRCHelper.initAttrs(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRCHelper.onSizeChanged((View)this, w, h);
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.saveLayer(this.mRCHelper.mLayer, null, 31);
        super.dispatchDraw(canvas);
        this.mRCHelper.openHardware((View)this);
        this.mRCHelper.onClipDraw(canvas);
        canvas.restore();
    }

    public void draw(Canvas canvas) {
        this.mRCHelper.refreshRegion((View)this);
        if (this.mRCHelper.mClipBackground) {
            canvas.save();
            this.mRCHelper.openHardware((View)this);
            canvas.clipPath(this.mRCHelper.mClipPath);
            super.draw(canvas);
            canvas.restore();
        } else {
            super.draw(canvas);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 0 || action == 1) {
            this.refreshDrawableState();
        } else if (action == 3) {
            this.setPressed(false);
            this.refreshDrawableState();
        }
        if (!this.mRCHelper.mAreaRegion.contains((int)ev.getX(), (int)ev.getY())) {
            this.setPressed(false);
            this.refreshDrawableState();
            return false;
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void setClipBackground(boolean clipBackground) {
        this.mRCHelper.mClipBackground = clipBackground;
        this.invalidate();
    }

    @Override
    public void setRoundAsCircle(boolean roundAsCircle) {
        this.mRCHelper.mRoundAsCircle = roundAsCircle;
        this.invalidate();
    }

    @Override
    public void setRadius(int radius) {
        for (int i = 0; i < this.mRCHelper.radii.length; ++i) {
            this.mRCHelper.radii[i] = radius;
        }
        this.invalidate();
    }

    @Override
    public void setTopLeftRadius(int topLeftRadius) {
        this.mRCHelper.radii[0] = topLeftRadius;
        this.mRCHelper.radii[1] = topLeftRadius;
        this.invalidate();
    }

    @Override
    public void setTopRightRadius(int topRightRadius) {
        this.mRCHelper.radii[2] = topRightRadius;
        this.mRCHelper.radii[3] = topRightRadius;
        this.invalidate();
    }

    @Override
    public void setBottomRightRadius(int bottomRightRadius) {
        this.mRCHelper.radii[4] = bottomRightRadius;
        this.mRCHelper.radii[5] = bottomRightRadius;
        this.invalidate();
    }

    @Override
    public void setBottomLeftRadius(int bottomLeftRadius) {
        this.mRCHelper.radii[6] = bottomLeftRadius;
        this.mRCHelper.radii[7] = bottomLeftRadius;
        this.invalidate();
    }

    @Override
    public void setStrokeWidth(int strokeWidth) {
        this.mRCHelper.mStrokeWidth = strokeWidth;
        this.invalidate();
    }

    @Override
    public void setStrokeColor(int strokeColor) {
        this.mRCHelper.mStrokeColor = strokeColor;
        this.invalidate();
    }

    @Override
    public boolean isClipBackground() {
        return this.mRCHelper.mClipBackground;
    }

    @Override
    public boolean isRoundAsCircle() {
        return this.mRCHelper.mRoundAsCircle;
    }

    @Override
    public float getTopLeftRadius() {
        return this.mRCHelper.radii[0];
    }

    @Override
    public float getTopRightRadius() {
        return this.mRCHelper.radii[2];
    }

    @Override
    public float getBottomRightRadius() {
        return this.mRCHelper.radii[4];
    }

    @Override
    public float getBottomLeftRadius() {
        return this.mRCHelper.radii[6];
    }

    @Override
    public int getStrokeWidth() {
        return this.mRCHelper.mStrokeWidth;
    }

    @Override
    public int getStrokeColor() {
        return this.mRCHelper.mStrokeColor;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.mRCHelper.drawableStateChanged((View)this);
    }

    public void setChecked(boolean checked) {
        if (this.mRCHelper.mChecked != checked) {
            this.mRCHelper.mChecked = checked;
            this.refreshDrawableState();
            if (this.mRCHelper.mOnCheckedChangeListener != null) {
                this.mRCHelper.mOnCheckedChangeListener.onCheckedChanged((View)this, this.mRCHelper.mChecked);
            }
        }
    }

    public boolean isChecked() {
        return this.mRCHelper.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mRCHelper.mChecked);
    }

    public void setOnCheckedChangeListener(RoundHelper.OnCheckedChangeListener listener) {
        this.mRCHelper.mOnCheckedChangeListener = listener;
    }
}

