/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.recview.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import com.gymchina.android.recview.adapter.AbsRecAdapter;
import com.gymchina.android.recview.holder.AbsViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class HFRecAdapter<T>
extends AbsRecAdapter<T> {
    private static final String TAG = HFRecAdapter.class.getSimpleName();
    public static final int HEADER_TYPE = -1;
    public static final int FOOTER_TYPE = -2;
    private List<View> mHeaderViews = new ArrayList<View>();
    private List<View> mFooterViews = new ArrayList<View>();

    public HFRecAdapter(Context context) {
        super(context);
    }

    public abstract int getItemType(int var1);

    public abstract View createView(ViewGroup var1, int var2);

    public abstract AbsViewHolder onCreateViewHolder(View var1, int var2);

    public abstract void onBind(AbsViewHolder var1, T var2, int var3);

    public int getRealPosition(int position) {
        if (this.isHeader(position)) {
            return -1;
        }
        if (this.isFooter(position)) {
            return -2;
        }
        return position - this.getHeaderViewNum();
    }

    @Override
    public int getItemCount() {
        return this.getCount() + this.getHeaderViewNum() + this.getFooterViewNum();
    }

    public int getCount() {
        return super.getItemCount();
    }

    public int getFooterViewStartIndex() {
        return this.getCount() + this.getHeaderViewNum();
    }

    public int getHeaderViewNum() {
        if (this.mHeaderViews == null) {
            return 0;
        }
        return this.mHeaderViews.size();
    }

    public int getFooterViewNum() {
        if (this.mFooterViews == null) {
            return 0;
        }
        return this.mFooterViews.size();
    }

    public int getItemViewType(int position) {
        if (this.isHeader(position)) {
            return -1 * position;
        }
        if (this.isFooter(position)) {
            return -2 * position;
        }
        int type = this.getItemType(this.getRealPosition(position));
        if (type > 0) {
            return type;
        }
        throw new RuntimeException(TAG + " ItemViewType must > 0");
    }

    @Override
    protected View inflateView(ViewGroup parent, int viewType) {
        int position = viewType / -1;
        if (position >= 0 && this.isHeader(position)) {
            return parent;
        }
        position = viewType / -2;
        if (position >= 0 && this.isFooter(position)) {
            return parent;
        }
        return this.createView(parent, viewType);
    }

    @Override
    protected AbsViewHolder getViewHolder(View view, int viewType) {
        int position = viewType / -1;
        if (position >= 0 && this.isHeader(position)) {
            return new AbsViewHolder(this.removeIfHaveParent(this.mHeaderViews.get(position)));
        }
        position = viewType / -2;
        if (position >= 0 && this.isFooter(position)) {
            return new AbsViewHolder(this.removeIfHaveParent(this.mFooterViews.get(position - this.getFooterViewStartIndex())));
        }
        return this.onCreateViewHolder(view, viewType);
    }

    @Override
    protected void bindVHolder(AbsViewHolder holder, int position) {
        int realPos = this.getRealPosition(position);
        if (realPos < 0) {
            return;
        }
        this.onBind(holder, this.getItem(realPos), realPos);
    }

    public final void notifyAllChanged() {
        super.notifyDataSetChanged();
    }

    public final void notifyChanged(int position) {
        this.notifyRangeChanged(position, 1);
    }

    public final void notifyRangeChanged(int position, int count) {
        super.notifyItemRangeChanged(position += this.getHeaderViewNum(), count);
    }

    public final void notifyInserted(int position) {
        this.notifyRangeInserted(position, 1);
    }

    public final void notifyRangeInserted(int position, int count) {
        super.notifyItemRangeInserted(position += this.getHeaderViewNum(), count);
    }

    public final void notifyRemoved(int position) {
        this.notifyItemRangeRemoved(position, 1);
    }

    public final void notifyRangeRemoved(int position, int count) {
        super.notifyItemRangeRemoved(position += this.getHeaderViewNum(), count);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)layoutManager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return HFRecAdapter.this.isFooter(position) || HFRecAdapter.this.isHeader(position) ? gridManager.getSpanCount() : 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
        if (layoutParams != null && layoutParams instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)layoutParams;
            params.setFullSpan(this.isHeader(holder.getLayoutPosition()) || this.isFooter(holder.getLayoutPosition()));
        }
    }

    public void notifyHeaderViewChanged(View view) {
        int index = this.mHeaderViews.indexOf(view);
        if (index >= 0) {
            super.notifyItemChanged(index);
        }
    }

    public void notifyFooterViewChanged(View view) {
        int index = this.mFooterViews.indexOf(view);
        if (index >= 0) {
            super.notifyItemChanged(this.getFooterViewStartIndex() + index);
        }
    }

    protected View removeIfHaveParent(@NonNull View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(view);
        }
        return view;
    }

    public <T extends RelativeLayout> void addHeaderView(T view) {
        if (this.mHeaderViews.contains(view)) {
            return;
        }
        this.mHeaderViews.add((View)view);
        super.notifyItemInserted(this.mHeaderViews.indexOf(view));
    }

    public <T extends RelativeLayout> void addHeaderViewToTop(T view) {
        if (this.mHeaderViews.contains(view)) {
            return;
        }
        this.mHeaderViews.add(0, (View)view);
        super.notifyItemInserted(0);
    }

    public void addFooterView(View view) {
        if (this.mFooterViews.contains(view)) {
            return;
        }
        this.mFooterViews.add(view);
        super.notifyItemInserted(this.getFooterViewStartIndex() + this.mFooterViews.indexOf(view));
    }

    public void removeAllHeaderView() {
        if (this.getHeaderViewNum() == 0) {
            return;
        }
        int size = this.getHeaderViewNum();
        this.mHeaderViews.clear();
        super.notifyItemRangeRemoved(0, size);
    }

    public void removeAllFooterView() {
        if (this.getFooterViewNum() == 0) {
            return;
        }
        int size = this.getFooterViewNum();
        this.mFooterViews.clear();
        super.notifyItemRangeRemoved(this.getFooterViewStartIndex(), size);
    }

    public void removeHeaderView(View view) {
        if (this.getHeaderViewNum() == 0) {
            return;
        }
        if (!this.mHeaderViews.contains(view)) {
            return;
        }
        int index = this.mHeaderViews.indexOf(view);
        if (index == -1) {
            return;
        }
        this.mHeaderViews.remove(view);
        super.notifyItemRemoved(index);
    }

    public void removeFooterView(View view) {
        if (this.getFooterViewNum() == 0) {
            return;
        }
        if (!this.mFooterViews.contains(view)) {
            return;
        }
        int index = this.mFooterViews.indexOf(view);
        if (index == -1) {
            return;
        }
        this.mFooterViews.remove(view);
        super.notifyItemRemoved(this.getFooterViewStartIndex() + index);
    }

    private boolean isHeader(int position) {
        return this.getHeaderViewNum() > 0 && position < this.getHeaderViewNum();
    }

    private boolean isFooter(int position) {
        return this.getFooterViewNum() > 0 && position >= this.getFooterViewStartIndex();
    }
}

