/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.processor;

import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import com.gymchina.android.vrefresh.VerticalRefreshLayout;
import com.gymchina.android.vrefresh.processor.Decorator;
import com.gymchina.android.vrefresh.processor.IDecorator;
import com.gymchina.android.vrefresh.utils.ScrollingUtil;

public class OverScrollDecorator
extends Decorator {
    private float mVelocityY;
    private static final int OVER_SCROLL_MIN_VX = 3000;
    private static final int MSG_START_COMPUTE_SCROLL = 0;
    private static final int MSG_CONTINUE_COMPUTE_SCROLL = 1;
    private static final int MSG_STOP_COMPUTE_SCROLL = 2;
    private int cur_delay_times = 0;
    private static final int ALL_DELAY_TIMES = 60;
    private boolean preventTopOverScroll = false;
    private boolean preventBottomOverScroll = false;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            int mTouchSlop = OverScrollDecorator.this.cp.getTouchSlop();
            switch (msg.what) {
                case 0: {
                    OverScrollDecorator.this.cur_delay_times = -1;
                }
                case 1: {
                    OverScrollDecorator.this.cur_delay_times++;
                    View mChildView = OverScrollDecorator.this.cp.getTargetView();
                    if (OverScrollDecorator.this.cp.allowOverScroll()) {
                        if (OverScrollDecorator.this.mVelocityY >= 3000.0f) {
                            if (ScrollingUtil.isViewToTop(mChildView, mTouchSlop)) {
                                OverScrollDecorator.this.cp.getAnimProcessor().animOverScrollTop(OverScrollDecorator.this.mVelocityY, OverScrollDecorator.this.cur_delay_times);
                                OverScrollDecorator.this.mVelocityY = 0.0f;
                                OverScrollDecorator.this.cur_delay_times = 60;
                            }
                        } else if (OverScrollDecorator.this.mVelocityY <= -3000.0f && ScrollingUtil.isViewToBottom(mChildView, mTouchSlop)) {
                            OverScrollDecorator.this.cp.getAnimProcessor().animOverScrollBottom(OverScrollDecorator.this.mVelocityY, OverScrollDecorator.this.cur_delay_times);
                            OverScrollDecorator.this.mVelocityY = 0.0f;
                            OverScrollDecorator.this.cur_delay_times = 60;
                        }
                    }
                    if (OverScrollDecorator.this.cur_delay_times >= 60) break;
                    OverScrollDecorator.this.mHandler.sendEmptyMessageDelayed(1, 10L);
                    break;
                }
                case 2: {
                    OverScrollDecorator.this.cur_delay_times = 60;
                }
            }
        }
    };

    public OverScrollDecorator(VerticalRefreshLayout.CoContext processor, IDecorator decorator1) {
        super(processor, decorator1);
    }

    @Override
    public boolean interceptTouchEvent(MotionEvent ev) {
        return this.decorator != null && this.decorator.interceptTouchEvent(ev);
    }

    @Override
    public boolean dealTouchEvent(MotionEvent e) {
        return this.decorator != null && this.decorator.dealTouchEvent(e);
    }

    @Override
    public void onFingerDown(MotionEvent ev) {
        if (this.decorator != null) {
            this.decorator.onFingerDown(ev);
        }
        this.preventTopOverScroll = ScrollingUtil.isViewToTop(this.cp.getTargetView(), this.cp.getTouchSlop());
        this.preventBottomOverScroll = ScrollingUtil.isViewToBottom(this.cp.getTargetView(), this.cp.getTouchSlop());
    }

    @Override
    public void onFingerScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY, float velocityY) {
        if (this.decorator != null) {
            this.decorator.onFingerScroll(e1, e2, distanceX, distanceY, velocityY);
        }
    }

    @Override
    public void onFingerFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.decorator != null) {
            this.decorator.onFingerFling(e1, e2, velocityX, velocityY);
        }
        if (!this.cp.enableOverScroll()) {
            return;
        }
        int dy = (int)(e2.getY() - e1.getY());
        if (dy < -this.cp.getTouchSlop() && this.preventBottomOverScroll) {
            return;
        }
        if (dy > this.cp.getTouchSlop() && this.preventTopOverScroll) {
            return;
        }
        this.mVelocityY = velocityY;
        if (Math.abs(this.mVelocityY) >= 3000.0f) {
            this.mHandler.sendEmptyMessage(0);
        } else {
            this.mVelocityY = 0.0f;
            this.cur_delay_times = 60;
        }
    }
}

