/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.header.progresslayout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;

public class CircleImageView
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.75f;
    private static final float SHADOW_RADIUS = 3.5f;
    private static final int SHADOW_ELEVATION = 4;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;

    public CircleImageView(Context context, int color, float radius) {
        super(context);
        ShapeDrawable circle;
        float density = this.getContext().getResources().getDisplayMetrics().density;
        int diameter = (int)(radius * density * 2.0f);
        int shadowYOffset = (int)(density * 1.75f);
        int shadowXOffset = (int)(density * 0.0f);
        this.mShadowRadius = (int)(density * 3.5f);
        if (this.elevationSupported()) {
            circle = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)this, (float)(4.0f * density));
        } else {
            OvalShadow oval = new OvalShadow(this.mShadowRadius, diameter);
            circle = new ShapeDrawable((Shape)oval);
            ViewCompat.setLayerType((View)this, (int)1, (Paint)circle.getPaint());
            circle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x1E000000);
            int padding = this.mShadowRadius;
            this.setPadding(padding, padding, padding, padding);
        }
        circle.getPaint().setColor(color);
        this.setBackgroundDrawable((Drawable)circle);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.elevationSupported()) {
            this.setMeasuredDimension(this.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    public void onAnimationStart() {
        super.onAnimationStart();
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setBackgroundColorRes(int colorRes) {
        this.setBackgroundColor(this.getContext().getResources().getColor(colorRes));
    }

    public void setBackgroundColor(int color) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(color);
        }
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int shadowRadius, int circleDiameter) {
            CircleImageView.this.mShadowRadius = shadowRadius;
            this.mCircleDiameter = circleDiameter;
            this.mRadialGradient = new RadialGradient((float)(this.mCircleDiameter / 2), (float)(this.mCircleDiameter / 2), (float)CircleImageView.this.mShadowRadius, new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP);
            this.mShadowPaint.setShader((Shader)this.mRadialGradient);
        }

        public void draw(Canvas canvas, Paint paint) {
            int viewWidth = CircleImageView.this.getWidth();
            int viewHeight = CircleImageView.this.getHeight();
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2 + CircleImageView.this.mShadowRadius), this.mShadowPaint);
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

