/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.lrefresh;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gymchina.android.lrefresh.RefreshCallBack;
import com.gymchina.android.lrefresh.RefreshHeader;
import com.gymchina.android.lrefresh.header.MaterialRefreshHeader;
import com.gymchina.android.recview.listener.OnRefreshScrollListener;

public class LandscapeRefreshLayout
extends FrameLayout {
    private static final int DURATION = 150;
    private Context context;
    private RefreshHeader leftRefreshHeader;
    private RefreshHeader rightRefreshHeader;
    private View mTargetView;
    private View leftHeaderView;
    private View rightHeaderView;
    private RefreshCallBack refreshCallback;
    protected boolean enableLeftRefresh = true;
    protected boolean enableRightRefresh = true;
    private int touchSlop;
    private int dragMarginPx;
    private int leftHeaderWidth;
    private int rightHeaderWidth;
    private int dragMaxHeaderWidth;
    private int mLastInterceptX;
    private int mLastInterceptY;
    private int mLastX;
    private int mLastY;
    private float mTargetTranslationX = 0.0f;
    private int headerState = -1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private static final int REFRESH_STATE_IDLE = 0;
    private static final int REFRESH_STATE_START = 1;
    private static final int REFRESH_STATE_DRAGGING = 2;
    private static final int REFRESH_STATE_READY_TO_RELEASE = 3;
    private static final int REFRESH_STATE_REFRESHING = 4;
    private int refreshState = 0;
    private OnRefreshScrollListener mRefreshScrollListener;

    public LandscapeRefreshLayout(Context context) {
        super(context);
        this.init();
    }

    public LandscapeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LandscapeRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setEnableRefresh(boolean enable) {
        this.setEnableLeftRefresh(enable);
        this.setEnableRightRefresh(enable);
    }

    public void setEnableLeftRefresh(boolean enable) {
        this.enableLeftRefresh = enable;
        if (this.leftHeaderView != null) {
            if (this.enableLeftRefresh) {
                this.leftHeaderView.setVisibility(0);
            } else {
                this.leftHeaderView.setVisibility(8);
            }
        }
    }

    public void setEnableRightRefresh(boolean enable) {
        this.enableRightRefresh = enable;
        if (this.rightHeaderView != null) {
            if (this.enableRightRefresh) {
                this.rightHeaderView.setVisibility(0);
            } else {
                this.rightHeaderView.setVisibility(8);
            }
        }
    }

    public void addDefaultRefreshHeader(RefreshCallBack callback) {
        if (this.refreshCallback == null) {
            this.setRefreshCallback(callback);
        }
        if (this.leftHeaderView == null) {
            this.setRefreshHeader(new MaterialRefreshHeader(0), 0);
        }
        if (this.rightHeaderView == null) {
            this.setRefreshHeader(new MaterialRefreshHeader(1), 1);
        }
    }

    public void setRefreshCallback(RefreshCallBack callback) {
        this.refreshCallback = callback;
    }

    private void init() {
        this.context = this.getContext();
        this.touchSlop = ViewConfiguration.get((Context)this.context).getScaledTouchSlop();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.leftHeaderView != null) {
            this.leftHeaderWidth = this.leftHeaderView.getMeasuredWidth();
            this.dragMarginPx = (int)((double)this.leftHeaderWidth * 0.6);
            this.dragMaxHeaderWidth = this.leftHeaderWidth + this.dragMarginPx;
        }
        if (this.rightHeaderView != null) {
            this.rightHeaderWidth = this.rightHeaderView.getMeasuredWidth();
            if (this.dragMarginPx == 0) {
                this.dragMarginPx = (int)((double)this.rightHeaderWidth * 0.6);
                this.dragMaxHeaderWidth = this.rightHeaderWidth + this.dragMarginPx;
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.mTargetView == null) {
            this.findTargetView();
            if (this.mTargetView == null) {
                return;
            }
        }
        if (this.refreshState == 0) {
            if (this.leftHeaderView != null) {
                this.leftHeaderView.setTranslationX((float)(-this.leftHeaderWidth));
            }
            if (this.rightHeaderView != null) {
                this.rightHeaderView.setTranslationX((float)this.rightHeaderWidth);
            }
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    private void findTargetView() {
        if (this.mTargetView == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.equals(this.leftHeaderView) || child.equals(this.rightHeaderView)) continue;
                this.mTargetView = child;
                break;
            }
        }
    }

    public void setRefreshScrollListener(OnRefreshScrollListener listener) {
        this.mRefreshScrollListener = listener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        switch (ev.getAction()) {
            case 0: {
                this.mLastX = this.mLastInterceptX = x;
                this.mLastY = this.mLastInterceptY = y;
                break;
            }
            case 2: {
                int deltaX = x - this.mLastInterceptX;
                int deltaY = y - this.mLastInterceptY;
                this.mLastX = this.mLastInterceptX = x;
                this.mLastY = this.mLastInterceptY = y;
                if (Math.abs(deltaX) <= Math.abs(deltaY)) break;
                if (this.enableLeftRefresh && this.leftHeaderView != null && deltaX > 0 && !this.canChildScrollRight() && this.refreshState != 4) {
                    this.headerState = 0;
                    this.refreshState = 1;
                    this.leftRefreshHeader.onStart(0, this.leftHeaderView);
                    return true;
                }
                if (!this.enableRightRefresh || this.rightHeaderView == null || deltaX >= 0 || this.canChildScrollLeft() || this.refreshState == 4) break;
                this.headerState = 1;
                this.refreshState = 1;
                this.rightRefreshHeader.onStart(1, this.rightHeaderView);
                return true;
            }
            case 1: 
            case 3: {
                this.mLastInterceptX = 0;
                this.mLastInterceptY = 0;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mLastX = x;
                this.mLastY = y;
                break;
            }
            case 2: {
                int deltaX = x - this.mLastX;
                this.mLastX = x;
                this.mLastY = y;
                float dampingDX = (float)deltaX * (1.0f - Math.abs(this.mTargetTranslationX / (float)this.dragMaxHeaderWidth));
                this.mTargetTranslationX += dampingDX;
                if (this.headerState == 0) {
                    if (this.mTargetTranslationX <= 0.0f) {
                        Log.d((String)"xiao1", (String)"test1");
                        this.mTargetTranslationX = 0.0f;
                        this.mTargetView.setTranslationX(0.0f);
                        if (this.mRefreshScrollListener != null) {
                            this.mRefreshScrollListener.onResetLocation(0);
                        }
                    } else if (this.mTargetTranslationX >= (float)this.dragMaxHeaderWidth) {
                        Log.d((String)"xiao1", (String)"test2");
                        this.mTargetTranslationX = this.dragMaxHeaderWidth;
                        this.mTargetView.setTranslationX(this.mTargetTranslationX);
                        if (this.mRefreshScrollListener != null) {
                            this.mRefreshScrollListener.onScrolledOnRefresh((int)this.mTargetTranslationX, 0, 0);
                        }
                    } else {
                        Log.d((String)"xiao1", (String)"test3");
                        this.mTargetView.setTranslationX(this.mTargetTranslationX);
                        if (this.mRefreshScrollListener != null) {
                            this.mRefreshScrollListener.onScrolledOnRefresh((int)this.mTargetTranslationX, 0, 0);
                        }
                        if (this.refreshState != 3 && this.mTargetTranslationX >= (float)this.leftHeaderWidth) {
                            this.refreshState = 3;
                            this.leftRefreshHeader.onReadyToRelease(this.leftHeaderView);
                        } else {
                            this.refreshState = 2;
                            float percent = Math.abs(this.mTargetTranslationX / (float)this.leftHeaderWidth);
                            this.leftRefreshHeader.onDragging(this.mTargetTranslationX, percent, this.leftHeaderView);
                        }
                    }
                    this.leftHeaderView.setTranslationX((float)(-this.leftHeaderWidth) + this.mTargetTranslationX);
                } else if (this.headerState == 1) {
                    if (this.mTargetTranslationX >= 0.0f) {
                        Log.d((String)"xiao1", (String)"test4");
                        this.mTargetTranslationX = 0.0f;
                        this.mTargetView.setTranslationX(0.0f);
                        if (this.mRefreshScrollListener != null) {
                            this.mRefreshScrollListener.onResetLocation(0);
                        }
                    } else if (this.mTargetTranslationX <= (float)(-this.dragMaxHeaderWidth)) {
                        Log.d((String)"xiao1", (String)"test5");
                        this.mTargetTranslationX = -this.dragMaxHeaderWidth;
                        this.mTargetView.setTranslationX(this.mTargetTranslationX);
                        if (this.mRefreshScrollListener != null) {
                            this.mRefreshScrollListener.onScrolledOnRefresh((int)this.mTargetTranslationX, 0, 0);
                        }
                    } else {
                        Log.d((String)"xiao1", (String)"test6");
                        this.mTargetView.setTranslationX(this.mTargetTranslationX);
                        if (this.mRefreshScrollListener != null) {
                            this.mRefreshScrollListener.onScrolledOnRefresh((int)this.mTargetTranslationX, 0, 0);
                        }
                        if (this.refreshState != 3 && this.mTargetTranslationX <= (float)(-this.rightHeaderWidth)) {
                            this.refreshState = 3;
                            this.rightRefreshHeader.onReadyToRelease(this.rightHeaderView);
                        } else {
                            this.refreshState = 2;
                            float percent = Math.abs(this.mTargetTranslationX / (float)this.rightHeaderWidth);
                            this.rightRefreshHeader.onDragging(this.mTargetTranslationX, percent, this.rightHeaderView);
                        }
                    }
                    this.rightHeaderView.setTranslationX((float)this.rightHeaderWidth + this.mTargetTranslationX);
                }
                return true;
            }
            case 1: 
            case 3: {
                this.mLastInterceptX = 0;
                this.mLastX = 0;
                this.mLastInterceptY = 0;
                this.mLastY = 0;
                if (this.headerState == 0) {
                    if (this.mTargetTranslationX < (float)this.leftHeaderWidth) {
                        Log.d((String)"xiao1", (String)"test7");
                        this.smoothRelease();
                    } else {
                        Log.d((String)"xiao1", (String)"test8");
                        this.smoothLocateToRefresh();
                    }
                } else if (this.headerState == 1) {
                    if (this.mTargetTranslationX > (float)(-this.rightHeaderWidth)) {
                        Log.d((String)"xiao1", (String)"test9");
                        this.smoothRelease();
                    } else {
                        Log.d((String)"xiao1", (String)"test10");
                        this.smoothLocateToRefresh();
                    }
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void smoothRelease() {
        if (this.mTargetView != null) {
            this.mTargetView.animate().translationX(0.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    LandscapeRefreshLayout.this.refreshState = 0;
                    LandscapeRefreshLayout.this.headerState = -1;
                    LandscapeRefreshLayout.this.mTargetTranslationX = 0.0f;
                }
            }).start();
            if (this.mRefreshScrollListener != null) {
                this.mRefreshScrollListener.onResetLocation(150);
            }
        } else {
            this.refreshState = 0;
            this.headerState = -1;
            this.mTargetTranslationX = 0.0f;
        }
        if (this.headerState == 0) {
            if (this.leftHeaderView != null) {
                this.leftRefreshHeader.onStart(0, this.leftHeaderView);
                this.leftHeaderView.animate().translationX((float)(-this.leftHeaderWidth)).setDuration(150L).start();
                if (this.mRefreshScrollListener != null) {
                    this.mRefreshScrollListener.onScrolledOnRefresh(-this.leftHeaderWidth, 0, 150);
                }
            }
        } else if (this.headerState == 1 && this.rightHeaderView != null) {
            this.rightRefreshHeader.onStart(0, this.rightHeaderView);
            this.rightHeaderView.animate().translationX((float)this.rightHeaderWidth).setDuration(150L).start();
            if (this.mRefreshScrollListener != null) {
                this.mRefreshScrollListener.onScrolledOnRefresh(this.rightHeaderWidth, 0, 150);
            }
        }
    }

    private void smoothLocateToRefresh() {
        if (this.headerState == 0 && this.leftHeaderView != null) {
            this.refreshState = 4;
            this.leftHeaderView.animate().translationX(0.0f).setDuration(150L).start();
            this.leftRefreshHeader.onRefreshing(this.leftHeaderView);
            this.mTargetView.animate().translationX((float)this.leftHeaderWidth).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    LandscapeRefreshLayout.this.mTargetTranslationX = LandscapeRefreshLayout.this.leftHeaderWidth;
                    if (LandscapeRefreshLayout.this.refreshCallback != null) {
                        if (LandscapeRefreshLayout.this.headerState == 0) {
                            LandscapeRefreshLayout.this.refreshCallback.onLeftRefreshing();
                        } else {
                            LandscapeRefreshLayout.this.refreshCallback.onRightRefreshing();
                        }
                    }
                }
            }).start();
            if (this.mRefreshScrollListener != null) {
                this.mRefreshScrollListener.onScrolledOnRefresh(this.leftHeaderWidth, 0, 150);
            }
        } else if (this.headerState == 1 && this.rightHeaderView != null) {
            this.refreshState = 4;
            this.rightHeaderView.animate().translationXBy(-this.mTargetTranslationX - (float)this.rightHeaderWidth).setDuration(150L).start();
            this.rightRefreshHeader.onRefreshing(this.rightHeaderView);
            this.mTargetView.animate().translationX((float)(-this.rightHeaderWidth)).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (LandscapeRefreshLayout.this.refreshCallback != null) {
                        if (LandscapeRefreshLayout.this.headerState == 0) {
                            LandscapeRefreshLayout.this.refreshCallback.onLeftRefreshing();
                        } else {
                            LandscapeRefreshLayout.this.refreshCallback.onRightRefreshing();
                        }
                    }
                    LandscapeRefreshLayout.this.mTargetTranslationX = -LandscapeRefreshLayout.this.rightHeaderWidth;
                }
            }).start();
            if (this.mRefreshScrollListener != null) {
                this.mRefreshScrollListener.onScrolledOnRefresh(-this.rightHeaderWidth, 0, 150);
            }
        }
    }

    public void onRefreshComplete() {
        if (this.headerState == -1) {
            return;
        }
        this.smoothRelease();
    }

    public void startAutoRefresh(final int leftOrRight) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (LandscapeRefreshLayout.this.headerState != -1) {
                    return;
                }
                if (leftOrRight == 0 && LandscapeRefreshLayout.this.leftHeaderView == null) {
                    return;
                }
                if (leftOrRight == 1 && LandscapeRefreshLayout.this.rightHeaderView == null) {
                    return;
                }
                LandscapeRefreshLayout.this.headerState = leftOrRight;
                LandscapeRefreshLayout.this.smoothLocateToRefresh();
            }
        }, 100L);
    }

    private void setLeftHeadView(View view) {
        this.leftHeaderView = view;
        ((FrameLayout.LayoutParams)this.leftHeaderView.getLayoutParams()).gravity = 0x800003;
        this.addView(this.leftHeaderView, 0);
    }

    private void setRightHeadView(View view) {
        this.rightHeaderView = view;
        ((FrameLayout.LayoutParams)this.rightHeaderView.getLayoutParams()).gravity = 0x800005;
        this.addView(this.rightHeaderView, 0);
    }

    public void setRefreshHeader(RefreshHeader header, int startOrEnd) {
        if (startOrEnd == 0) {
            this.leftRefreshHeader = header;
            this.setLeftHeadView(this.leftRefreshHeader.getView((ViewGroup)this));
        } else if (startOrEnd == 1) {
            this.rightRefreshHeader = header;
            this.setRightHeadView(this.rightRefreshHeader.getView((ViewGroup)this));
        }
    }

    public boolean canChildScrollRight() {
        return ViewCompat.canScrollHorizontally((View)this.mTargetView, (int)-1);
    }

    public boolean canChildScrollLeft() {
        return ViewCompat.canScrollHorizontally((View)this.mTargetView, (int)1);
    }

    public static int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

