/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    public static final int HOUR = 3600000;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final String YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD_HM = "yyyy-MM-dd HH:mm";
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMD_UNLINE = "yyyyMMdd";
    public static final String MD_HM = "MM\u6708dd\u65e5 HH:mm";
    public static final String HHMM = "HH:mm";

    private DateUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static String formatDate(long date, String pattern) {
        SimpleDateFormat s = new SimpleDateFormat(pattern);
        return s.format(date);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return DateUtil.formatDate(date.getTime(), pattern);
    }

    public static String formatDate(long date) {
        return DateUtil.formatDate(date, YMD_HMS);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtil.formatDate(date.getTime());
    }

    public static String getToday() {
        return DateUtil.formatDate(System.currentTimeMillis(), YMD_HMS);
    }

    public static int dayForWeek(long time) {
        Date date = new Date(time);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(date.getYear(), date.getMonth(), date.getDay());
        return cal.get(7);
    }
}

