/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.utils;

import android.app.ActivityManager;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.gymchina.android.framework.base.AbsApplication;
import com.gymchina.android.framework.utils.CollectionUtil;
import java.util.List;

public final class AppUtil {
    private AppUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void restart() {
        AbsApplication application = AbsApplication.instance();
        Intent intent = application.getPackageManager().getLaunchIntentForPackage(application.getPackageName());
        if (intent != null) {
            intent.addFlags(0x4000000);
            application.startActivity(intent);
        }
    }

    public static int getVersionCode() {
        AbsApplication application = AbsApplication.instance();
        if (application == null) {
            return -1;
        }
        try {
            return application.getPackageManager().getPackageInfo((String)application.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return -1;
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    public static String getVersionName() {
        AbsApplication application = AbsApplication.instance();
        if (application == null) {
            return null;
        }
        try {
            return application.getPackageManager().getPackageInfo((String)application.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static boolean isTopActivity(String packageName) {
        AbsApplication application = AbsApplication.instance();
        if (application == null) {
            return false;
        }
        ActivityManager am = (ActivityManager)application.getSystemService("activity");
        if (am == null) {
            return false;
        }
        List processList = am.getRunningAppProcesses();
        if (CollectionUtil.isEmpty(processList)) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : processList) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static boolean isRuningService(String serviceName) {
        AbsApplication application = AbsApplication.instance();
        if (application == null) {
            return false;
        }
        ActivityManager am = (ActivityManager)application.getSystemService("activity");
        if (am == null) {
            return false;
        }
        List list = am.getRunningServices(400);
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (ActivityManager.RunningServiceInfo info : list) {
            if (!info.service.getClassName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }
}

