/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.utils;

import android.content.Context;
import android.support.annotation.StringRes;
import android.widget.Toast;
import com.gymchina.android.framework.base.AbsApplication;
import com.gymchina.android.framework.utils.TaskUtil;

public final class ToastUtil {
    private ToastUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void showToast(Context context, CharSequence text, int duration) {
        if (context == null) {
            context = AbsApplication.instance();
        }
        Toast.makeText((Context)context, (CharSequence)text, (int)duration).show();
    }

    public static void showToast(Context context, @StringRes int resId, int duration) {
        if (context == null) {
            context = AbsApplication.instance();
        }
        Toast.makeText((Context)context, (int)resId, (int)duration).show();
    }

    public static void showToast(Context context, CharSequence text) {
        ToastUtil.showToast(context, text, 0);
    }

    public static void showToast(Context context, @StringRes int resId) {
        ToastUtil.showToast(context, resId, 0);
    }

    public static void showToast(String text) {
        ToastUtil.showToast(null, text);
    }

    public static void showToast(@StringRes int resId) {
        ToastUtil.showToast(null, resId);
    }

    public static void showToastSafely(String text) {
        TaskUtil.getMainHandler().post(() -> ToastUtil.showToast(text));
    }

    public static void showToastSafely(@StringRes int resId) {
        TaskUtil.getMainHandler().post(() -> ToastUtil.showToast(resId));
    }
}

