/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.utils;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    private StringUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isNull(String str) {
        return TextUtils.isEmpty((CharSequence)str) || "null".equalsIgnoreCase(str);
    }

    public static boolean isNotNull(String str) {
        return !StringUtil.isNull(str);
    }

    public static String getStrOrDefStr(String str, String defStr) {
        return StringUtil.isNotNull(str) ? str : defStr;
    }

    public static String getUrlHost(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        return Uri.parse((String)url).getHost();
    }

    public static boolean isQQ(String qq) {
        Pattern p = Pattern.compile("[1-9][0-9]{4,14}");
        Matcher m = p.matcher(qq);
        return m.matches();
    }

    public static boolean isTel(String tel) {
        Pattern p = Pattern.compile("((13[0-9])|(15[^4\uff0c\\D])|(18[0,5-9]))\\d{8}$");
        Pattern p1 = Pattern.compile("^(0[0-9]{2,3})?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?$");
        boolean isExist = false;
        if (p.matcher(tel).matches()) {
            isExist = true;
        }
        if (p1.matcher(tel).matches()) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isMobilePhone(String tel) {
        Pattern p = Pattern.compile("(1)\\d{10}$");
        boolean isExist = false;
        if (p.matcher(tel).matches()) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isEmail(String str) {
        Pattern p1 = Pattern.compile("\\w+@(\\w+.)+[a-z]{2,3}");
        Matcher m = p1.matcher(str);
        return m.matches();
    }

    public static String getMd5String(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = StringUtil.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getFromBase64(String encodeStr) {
        byte[] b = Base64.decode((String)encodeStr, (int)0);
        String s = null;
        try {
            s = new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }
}

