/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.network.interceptor;

import android.content.Context;
import com.gymchina.android.framework.base.AbsApplication;
import com.gymchina.android.framework.utils.NetInfoUtil;
import java.io.IOException;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CacheInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        int maxAge = 3600;
        int maxStale = 86400;
        Request request = chain.request();
        request = NetInfoUtil.isConnected((Context)AbsApplication.instance()) ? request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build() : request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
        Response response = chain.proceed(request);
        response = NetInfoUtil.isConnected((Context)AbsApplication.instance()) ? response.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, max-age=" + maxAge).build() : response.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale).build();
        return response;
    }
}

