/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.common.utils;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import com.gymchina.android.common.utils.LogUtil;
import com.gymchina.android.common.utils.SpUtil;

public final class ScreenUtil {
    protected static int WIDTH;
    protected static int HEIGHT;
    protected static int DENSITY_DPI;
    protected static float DENSITY;

    private ScreenUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int dp2px(Context ctx, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)ctx.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context ctx, float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)ctx.getResources().getDisplayMetrics());
    }

    public static int px2dp(Context context, float pxValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return Math.round(pxValue / density);
    }

    protected static void initDisplay(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        WIDTH = dm.widthPixels;
        HEIGHT = dm.heightPixels;
        DENSITY_DPI = dm.densityDpi;
        DENSITY = dm.density;
    }

    public static float getDensity(Context context) {
        if (DENSITY == 0.0f) {
            DENSITY = context.getResources().getDisplayMetrics().density;
        }
        return DENSITY;
    }

    public static int getScreenHeight(Context context) {
        if (HEIGHT > 0) {
            return HEIGHT;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        HEIGHT = dm.heightPixels;
        return HEIGHT;
    }

    public static int getScreenWidth(Context context) {
        if (WIDTH > 0) {
            return WIDTH;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        WIDTH = dm.widthPixels;
        return WIDTH;
    }

    public static int getRtScreenHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            Display display = windowManager.getDefaultDisplay();
            return display.getHeight();
        }
        return -1;
    }

    public static int getRtScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            Display display = windowManager.getDefaultDisplay();
            return display.getWidth();
        }
        return -1;
    }

    public static int getMaxScreenSize(Context context) {
        if (WIDTH == 0 || HEIGHT == 0) {
            ScreenUtil.initDisplay(context);
        }
        return Math.max(WIDTH, HEIGHT);
    }

    public static int getMinScreenSize(Context context) {
        if (WIDTH == 0 || HEIGHT == 0) {
            ScreenUtil.initDisplay(context);
        }
        return Math.min(WIDTH, HEIGHT);
    }

    public static boolean isScreenOn(Context context) {
        try {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            boolean isScreenOn = true;
            if (powerManager != null) {
                isScreenOn = powerManager.isScreenOn();
            }
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            boolean isLocked = false;
            if (keyguardManager != null) {
                isLocked = keyguardManager.inKeyguardRestrictedInputMode();
            }
            return isScreenOn && !isLocked;
        }
        catch (Exception e) {
            LogUtil.e(e);
            return true;
        }
    }

    public static int getStatusBarHeight(Context context) {
        int statusBarHeight = SpUtil.getDefIntPrefs(context, "status_bar_height", 0);
        if (Build.VERSION.SDK_INT >= 28) {
            int notchHeight = SpUtil.getDefIntPrefs(context, "notch_height", 0);
            if (statusBarHeight >= notchHeight && notchHeight > 0) {
                SpUtil.saveDefIntPrefs(context, "status_bar_height", statusBarHeight);
                return statusBarHeight;
            }
            if (notchHeight >= statusBarHeight && statusBarHeight > 0) {
                SpUtil.saveDefIntPrefs(context, "status_bar_height", notchHeight);
                return notchHeight;
            }
        }
        if (statusBarHeight > 0) {
            return statusBarHeight;
        }
        try {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0 && (statusBarHeight = context.getResources().getDimensionPixelSize(resourceId)) > 0) {
                SpUtil.saveDefIntPrefs(context, "status_bar_height", statusBarHeight);
                return statusBarHeight;
            }
            statusBarHeight = ScreenUtil.dp2px(context, 22.0f);
            try {
                Class<?> clazz = Class.forName("com.android.internal.R$dimen");
                Object object = clazz.newInstance();
                int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
                statusBarHeight = context.getResources().getDimensionPixelSize(height);
                if (statusBarHeight > 0) {
                    SpUtil.saveDefIntPrefs(context, "status_bar_height", statusBarHeight);
                }
            }
            catch (Exception e) {
                LogUtil.e(e);
            }
        }
        catch (Exception e) {
            LogUtil.e(e);
        }
        return statusBarHeight;
    }

    public static boolean isFullScreen(Activity activity) {
        int flag = activity.getWindow().getAttributes().flags;
        return (flag & 0x400) == 1024 || (flag & 0x100) == 256;
    }
}

