/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import com.gymchina.android.agentweb.AbsAgentWebUIController;
import com.gymchina.android.agentweb.Action;
import com.gymchina.android.agentweb.ActionActivity;
import com.gymchina.android.agentweb.AgentWebPermissions;
import com.gymchina.android.agentweb.AgentWebUtils;
import com.gymchina.android.agentweb.IVideo;
import com.gymchina.android.agentweb.IndicatorController;
import com.gymchina.android.agentweb.LogUtils;
import com.gymchina.android.agentweb.MiddlewareWebChromeBase;
import com.gymchina.android.agentweb.PermissionInterceptor;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;

public class DefaultChromeClient
extends MiddlewareWebChromeBase {
    private WeakReference<Activity> mActivityWeakReference = null;
    private String TAG = DefaultChromeClient.class.getSimpleName();
    public static final String ANDROID_WEBCHROMECLIENT_PATH = "android.webkit.WebChromeClient";
    private WebChromeClient mWebChromeClient;
    private boolean mIsWrapper = false;
    private IVideo mIVideo;
    private PermissionInterceptor mPermissionInterceptor;
    private WebView mWebView;
    private String mOrigin = null;
    private GeolocationPermissions.Callback mCallback = null;
    public static final int FROM_CODE_INTENTION = 24;
    public static final int FROM_CODE_INTENTION_LOCATION = 96;
    private WeakReference<AbsAgentWebUIController> mAgentWebUIController = null;
    private IndicatorController mIndicatorController;
    private Object mFileChooser;
    private ActionActivity.PermissionListener mPermissionListener = new ActionActivity.PermissionListener(){

        @Override
        public void onRequestPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults, Bundle extras) {
            if (extras.getInt("KEY_FROM_INTENTION") == 96) {
                boolean hasPermission = AgentWebUtils.hasPermission((Context)DefaultChromeClient.this.mActivityWeakReference.get(), permissions);
                if (DefaultChromeClient.this.mCallback != null) {
                    if (hasPermission) {
                        DefaultChromeClient.this.mCallback.invoke(DefaultChromeClient.this.mOrigin, true, false);
                    } else {
                        DefaultChromeClient.this.mCallback.invoke(DefaultChromeClient.this.mOrigin, false, false);
                    }
                    DefaultChromeClient.this.mCallback = null;
                    DefaultChromeClient.this.mOrigin = null;
                }
                if (!hasPermission && null != DefaultChromeClient.this.mAgentWebUIController.get()) {
                    ((AbsAgentWebUIController)DefaultChromeClient.this.mAgentWebUIController.get()).onPermissionsDeny(AgentWebPermissions.LOCATION, "Location", "Location");
                }
            }
        }
    };

    DefaultChromeClient(Activity activity, IndicatorController indicatorController, WebChromeClient chromeClient, @Nullable IVideo iVideo, PermissionInterceptor permissionInterceptor, WebView webView) {
        super(chromeClient);
        this.mIndicatorController = indicatorController;
        this.mIsWrapper = chromeClient != null;
        this.mWebChromeClient = chromeClient;
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mIVideo = iVideo;
        this.mPermissionInterceptor = permissionInterceptor;
        this.mWebView = webView;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView(webView));
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        super.onProgressChanged(view, newProgress);
        if (this.mIndicatorController != null) {
            this.mIndicatorController.progress(view, newProgress);
        }
    }

    @Override
    public void onReceivedTitle(WebView view, String title) {
        if (this.mIsWrapper) {
            super.onReceivedTitle(view, title);
        }
    }

    @Override
    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onJsAlert", "public boolean android.webkit.WebChromeClient.onJsAlert", WebView.class, String.class, String.class, JsResult.class)) {
            return super.onJsAlert(view, url, message, result);
        }
        if (this.mAgentWebUIController.get() != null) {
            ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onJsAlert(view, url, message);
        }
        result.confirm();
        return true;
    }

    @Override
    public void onReceivedIcon(WebView view, Bitmap icon) {
        super.onReceivedIcon(view, icon);
    }

    @Override
    public void onGeolocationPermissionsHidePrompt() {
        super.onGeolocationPermissionsHidePrompt();
    }

    @Override
    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onGeolocationPermissionsShowPrompt", "public void android.webkit.WebChromeClient.onGeolocationPermissionsShowPrompt", String.class, GeolocationPermissions.Callback.class)) {
            super.onGeolocationPermissionsShowPrompt(origin, callback);
            return;
        }
        this.onGeolocationPermissionsShowPromptInternal(origin, callback);
    }

    private void onGeolocationPermissionsShowPromptInternal(String origin, GeolocationPermissions.Callback callback) {
        if (this.mPermissionInterceptor != null && this.mPermissionInterceptor.intercept(this.mWebView.getUrl(), AgentWebPermissions.LOCATION, "location")) {
            callback.invoke(origin, false, false);
            return;
        }
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (mActivity == null) {
            callback.invoke(origin, false, false);
            return;
        }
        List<String> deniedPermissions = null;
        deniedPermissions = AgentWebUtils.getDeniedPermissions(mActivity, AgentWebPermissions.LOCATION);
        if (deniedPermissions.isEmpty()) {
            LogUtils.i(this.TAG, "onGeolocationPermissionsShowPromptInternal:true");
            callback.invoke(origin, true, false);
        } else {
            Action mAction = Action.createPermissionsAction(deniedPermissions.toArray(new String[0]));
            mAction.setFromIntention(96);
            ActionActivity.setPermissionListener(this.mPermissionListener);
            this.mCallback = callback;
            this.mOrigin = origin;
            ActionActivity.start(mActivity, mAction);
        }
    }

    @Override
    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        block4: {
            try {
                if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onJsPrompt", "public boolean android.webkit.WebChromeClient.onJsPrompt", WebView.class, String.class, String.class, String.class, JsPromptResult.class)) {
                    return super.onJsPrompt(view, url, message, defaultValue, result);
                }
                if (this.mAgentWebUIController.get() != null) {
                    ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onJsPrompt(this.mWebView, url, message, defaultValue, result);
                }
            }
            catch (Exception e) {
                if (!LogUtils.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onJsConfirm", "public boolean android.webkit.WebChromeClient.onJsConfirm", WebView.class, String.class, String.class, JsResult.class)) {
            return super.onJsConfirm(view, url, message, result);
        }
        if (this.mAgentWebUIController.get() != null) {
            ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onJsConfirm(view, url, message, result);
        }
        return true;
    }

    @Override
    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onExceededDatabaseQuota", "android.webkit.WebChromeClient.onExceededDatabaseQuota", String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, WebStorage.QuotaUpdater.class)) {
            super.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
            return;
        }
        quotaUpdater.updateQuota(totalQuota * 2L);
    }

    @Override
    public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onReachedMaxAppCacheSize", "android.webkit.WebChromeClient.onReachedMaxAppCacheSize", Long.TYPE, Long.TYPE, WebStorage.QuotaUpdater.class)) {
            super.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
            return;
        }
        quotaUpdater.updateQuota(requiredStorage * 2L);
    }

    @Override
    @RequiresApi(api=21)
    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        LogUtils.i(this.TAG, "openFileChooser>=5.0");
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onShowFileChooser", "android.webkit.WebChromeClient.onShowFileChooser", WebView.class, ValueCallback.class, WebChromeClient.FileChooserParams.class)) {
            return super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
        }
        return this.openFileChooserAboveL(webView, filePathCallback, fileChooserParams);
    }

    @RequiresApi(api=21)
    private boolean openFileChooserAboveL(WebView webView, ValueCallback<Uri[]> valueCallbacks, WebChromeClient.FileChooserParams fileChooserParams) {
        LogUtils.i(this.TAG, "fileChooserParams:" + fileChooserParams.getAcceptTypes() + "  getTitle:" + fileChooserParams.getTitle() + " accept:" + Arrays.toString(fileChooserParams.getAcceptTypes()) + " length:" + fileChooserParams.getAcceptTypes().length + "  :" + fileChooserParams.isCaptureEnabled() + "  " + fileChooserParams.getFilenameHint() + "  intent:" + fileChooserParams.createIntent().toString() + "   mode:" + fileChooserParams.getMode());
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (mActivity == null || mActivity.isFinishing()) {
            return false;
        }
        return AgentWebUtils.showFileChooserCompat(mActivity, this.mWebView, valueCallbacks, fileChooserParams, this.mPermissionInterceptor, null, null, null);
    }

    @Override
    public void openFileChooser(ValueCallback<Uri> uploadFile, String acceptType, String capture) {
        LogUtils.i(this.TAG, "openFileChooser>=4.1");
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "openFileChooser", "android.webkit.WebChromeClient.openFileChooser", ValueCallback.class, String.class, String.class)) {
            super.openFileChooser(uploadFile, acceptType, capture);
            return;
        }
        this.createAndOpenCommonFileChooser(uploadFile, acceptType);
    }

    @Override
    public void openFileChooser(ValueCallback<Uri> valueCallback) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "openFileChooser", "android.webkit.WebChromeClient.openFileChooser", ValueCallback.class)) {
            super.openFileChooser(valueCallback);
            return;
        }
        Log.i((String)this.TAG, (String)"openFileChooser<3.0");
        this.createAndOpenCommonFileChooser(valueCallback, "*/*");
    }

    @Override
    public void openFileChooser(ValueCallback valueCallback, String acceptType) {
        Log.i((String)this.TAG, (String)"openFileChooser>3.0");
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "openFileChooser", "android.webkit.WebChromeClient.openFileChooser", ValueCallback.class, String.class)) {
            super.openFileChooser(valueCallback, acceptType);
            return;
        }
        this.createAndOpenCommonFileChooser(valueCallback, acceptType);
    }

    private void createAndOpenCommonFileChooser(ValueCallback valueCallback, String mimeType) {
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (mActivity == null || mActivity.isFinishing()) {
            valueCallback.onReceiveValue(new Object());
            return;
        }
        AgentWebUtils.showFileChooserCompat(mActivity, this.mWebView, null, null, this.mPermissionInterceptor, valueCallback, mimeType, null);
    }

    @Override
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        super.onConsoleMessage(consoleMessage);
        return true;
    }

    @Override
    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onShowCustomView", "android.webkit.WebChromeClient.onShowCustomView", View.class, WebChromeClient.CustomViewCallback.class)) {
            super.onShowCustomView(view, callback);
            return;
        }
        if (this.mIVideo != null) {
            this.mIVideo.onShowCustomView(view, callback);
        }
    }

    @Override
    public void onHideCustomView() {
        if (AgentWebUtils.isOverriedMethod(this.mWebChromeClient, "onHideCustomView", "android.webkit.WebChromeClient.onHideCustomView", new Class[0])) {
            super.onHideCustomView();
            return;
        }
        if (this.mIVideo != null) {
            this.mIVideo.onHideCustomView();
        }
    }
}

