/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.webview.agentweb.jsbridge;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.WebView;
import com.gymchina.android.webview.agentweb.jsbridge.BridgeHandler;
import com.gymchina.android.webview.agentweb.jsbridge.BridgeUtil;
import com.gymchina.android.webview.agentweb.jsbridge.BridgeWebViewClient;
import com.gymchina.android.webview.agentweb.jsbridge.CallBackFunction;
import com.gymchina.android.webview.agentweb.jsbridge.DefaultHandler;
import com.gymchina.android.webview.agentweb.jsbridge.Message;
import com.gymchina.android.webview.agentweb.jsbridge.WebViewJavascriptBridge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class BridgeWebView
extends WebView
implements WebViewJavascriptBridge {
    private final String TAG = BridgeWebView.class.getSimpleName();
    public static final String toLoadJs = "WebViewJavascriptBridge.js";
    Map<String, CallBackFunction> responseCallbacks = new HashMap<String, CallBackFunction>();
    Map<String, BridgeHandler> messageHandlers = new HashMap<String, BridgeHandler>();
    BridgeHandler defaultHandler = new DefaultHandler();
    private List<Message> startupMessage = new ArrayList<Message>();
    private long uniqueId = 0L;

    public List<Message> getStartupMessage() {
        return this.startupMessage;
    }

    public void setStartupMessage(List<Message> startupMessage) {
        this.startupMessage = startupMessage;
    }

    public BridgeWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BridgeWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public BridgeWebView(Context context) {
        super(context);
        this.init();
    }

    public void setDefaultHandler(BridgeHandler handler) {
        this.defaultHandler = handler;
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.setWebViewClient(this.generateBridgeWebViewClient());
    }

    protected BridgeWebViewClient generateBridgeWebViewClient() {
        return new BridgeWebViewClient(this);
    }

    void handlerReturnData(String url) {
        String functionName = BridgeUtil.getFunctionFromReturnUrl(url);
        CallBackFunction f = this.responseCallbacks.get(functionName);
        String data = BridgeUtil.getDataFromReturnUrl(url);
        if (f != null) {
            f.onCallBack(data);
            this.responseCallbacks.remove(functionName);
            return;
        }
    }

    @Override
    public void send(String data) {
        this.send(data, null);
    }

    @Override
    public void send(String data, CallBackFunction responseCallback) {
        this.doSend(null, data, responseCallback);
    }

    private void doSend(String handlerName, String data, CallBackFunction responseCallback) {
        Message m = new Message();
        if (!TextUtils.isEmpty((CharSequence)data)) {
            m.setData(data);
        }
        if (responseCallback != null) {
            String callbackStr = String.format("JAVA_CB_%s", ++this.uniqueId + "_" + SystemClock.currentThreadTimeMillis());
            this.responseCallbacks.put(callbackStr, responseCallback);
            m.setCallbackId(callbackStr);
        }
        if (!TextUtils.isEmpty((CharSequence)handlerName)) {
            m.setHandlerName(handlerName);
        }
        this.queueMessage(m);
    }

    private void queueMessage(Message m) {
        if (this.startupMessage != null) {
            this.startupMessage.add(m);
        } else {
            this.dispatchMessage(m);
        }
    }

    void dispatchMessage(Message m) {
        String messageJson = m.toJson();
        messageJson = messageJson.replaceAll("(\\\\)([^utrn])", "\\\\\\\\$1$2");
        messageJson = messageJson.replaceAll("(?<=[^\\\\])(\")", "\\\\\"");
        String javascriptCommand = String.format("javascript:WebViewJavascriptBridge._handleMessageFromNative('%s');", messageJson);
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl(javascriptCommand);
        }
    }

    void flushMessageQueue() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl("javascript:WebViewJavascriptBridge._fetchQueue();", data -> {
                List<Message> list = null;
                try {
                    list = Message.toArrayList(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                if (list == null || list.size() == 0) {
                    return;
                }
                for (int i = 0; i < list.size(); ++i) {
                    Message m = list.get(i);
                    String responseId = m.getResponseId();
                    if (!TextUtils.isEmpty((CharSequence)responseId)) {
                        CallBackFunction function = this.responseCallbacks.get(responseId);
                        String responseData = m.getResponseData();
                        function.onCallBack(responseData);
                        this.responseCallbacks.remove(responseId);
                        continue;
                    }
                    CallBackFunction responseFunction = null;
                    String callbackId = m.getCallbackId();
                    responseFunction = !TextUtils.isEmpty((CharSequence)callbackId) ? data1 -> {
                        Message responseMsg = new Message();
                        responseMsg.setResponseId(callbackId);
                        responseMsg.setResponseData(data1);
                        this.queueMessage(responseMsg);
                    } : data12 -> {};
                    BridgeHandler handler = !TextUtils.isEmpty((CharSequence)m.getHandlerName()) ? this.messageHandlers.get(m.getHandlerName()) : this.defaultHandler;
                    if (handler == null) continue;
                    handler.handler(m.getData(), responseFunction);
                }
            });
        }
    }

    public void loadUrl(String jsUrl, CallBackFunction returnCallback) {
        this.loadUrl(jsUrl);
        this.responseCallbacks.put(BridgeUtil.parseFunctionName(jsUrl), returnCallback);
    }

    public void registerHandler(String handlerName, BridgeHandler handler) {
        if (handler != null) {
            this.messageHandlers.put(handlerName, handler);
        }
    }

    public void callHandler(String handlerName, String data, CallBackFunction callBack) {
        this.doSend(handlerName, data, callBack);
    }
}

