/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.content.Context;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.gymchina.android.agentweb.AgentWebView;

public class NestedScrollAgentWebView
extends AgentWebView
implements NestedScrollingChild {
    private int mLastMotionY;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedYOffset;
    private NestedScrollingChildHelper mChildHelper;

    public NestedScrollAgentWebView(Context context) {
        super(context);
        this.init();
    }

    public NestedScrollAgentWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = false;
        MotionEvent trackedEvent = MotionEvent.obtain((MotionEvent)event);
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        if (action == 0) {
            this.mNestedYOffset = 0;
        }
        int y = (int)event.getY();
        event.offsetLocation(0.0f, (float)this.mNestedYOffset);
        switch (action) {
            case 0: {
                this.mLastMotionY = y;
                this.startNestedScroll(2);
                result = super.onTouchEvent(event);
                break;
            }
            case 2: {
                int dyUnconsumed;
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    trackedEvent.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                this.mLastMotionY = y - this.mScrollOffset[1];
                int oldY = this.getScrollY();
                int newScrollY = Math.max(0, oldY + deltaY);
                int dyConsumed = newScrollY - oldY;
                if (this.dispatchNestedScroll(0, dyConsumed, 0, dyUnconsumed = deltaY - dyConsumed, this.mScrollOffset)) {
                    this.mLastMotionY -= this.mScrollOffset[1];
                    trackedEvent.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                result = super.onTouchEvent(trackedEvent);
                trackedEvent.recycle();
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                this.stopNestedScroll();
                result = super.onTouchEvent(event);
            }
        }
        return result;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }
}

