/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.gymchina.android.agentweb.AbsAgentWebUIController;
import com.gymchina.android.agentweb.LogUtils;
import com.gymchina.android.agentweb.Provider;
import com.gymchina.android.agentweb.R;

public class WebParentLayout
extends FrameLayout
implements Provider<AbsAgentWebUIController> {
    private AbsAgentWebUIController mAgentWebUIController = null;
    private static final String TAG = WebParentLayout.class.getSimpleName();
    @LayoutRes
    private int mErrorLayoutRes;
    @IdRes
    private int mClickId = -1;
    private View mErrorView;
    private WebView mWebView;
    private FrameLayout mErrorLayout = null;

    WebParentLayout(@NonNull Context context) {
        this(context, null);
        LogUtils.i(TAG, "WebParentLayout");
    }

    WebParentLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    WebParentLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("WebParentLayout context must be activity or activity sub class .");
        }
        this.mErrorLayoutRes = R.layout.agentweb_error_page;
    }

    void bindController(AbsAgentWebUIController agentWebUIController) {
        this.mAgentWebUIController = agentWebUIController;
        this.mAgentWebUIController.bindWebParent(this, (Activity)this.getContext());
    }

    void showPageMainFrameError() {
        FrameLayout container = this.mErrorLayout;
        if (container != null) {
            container.setVisibility(0);
        } else {
            this.createErrorLayout();
            container = this.mErrorLayout;
        }
        View clickView = null;
        if (this.mClickId != -1 && (clickView = container.findViewById(this.mClickId)) != null) {
            clickView.setClickable(true);
        } else {
            container.setClickable(true);
        }
    }

    private void createErrorLayout() {
        final FrameLayout mFrameLayout = new FrameLayout(this.getContext());
        mFrameLayout.setBackgroundColor(-1);
        mFrameLayout.setId(R.id.agentweb_mainframe_error_container_id);
        if (this.mErrorView == null) {
            LayoutInflater mLayoutInflater = LayoutInflater.from((Context)this.getContext());
            LogUtils.i(TAG, "mErrorLayoutRes:" + this.mErrorLayoutRes);
            mLayoutInflater.inflate(this.mErrorLayoutRes, (ViewGroup)mFrameLayout, true);
        } else {
            mFrameLayout.addView(this.mErrorView);
        }
        ViewStub mViewStub = (ViewStub)this.findViewById(R.id.agentweb_mainframe_error_viewsub_id);
        int index = this.indexOfChild((View)mViewStub);
        this.removeViewInLayout((View)mViewStub);
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            this.mErrorLayout = mFrameLayout;
            this.addView((View)this.mErrorLayout, index, layoutParams);
        } else {
            this.mErrorLayout = mFrameLayout;
            this.addView((View)this.mErrorLayout, index);
        }
        mFrameLayout.setVisibility(0);
        if (this.mClickId != -1) {
            final View clickView = mFrameLayout.findViewById(this.mClickId);
            if (clickView != null) {
                clickView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (WebParentLayout.this.getWebView() != null) {
                            clickView.setClickable(false);
                            WebParentLayout.this.getWebView().reload();
                        }
                    }
                });
                return;
            }
            if (LogUtils.isDebug()) {
                LogUtils.e(TAG, "ClickView is null , cannot bind accurate view to refresh or reload .");
            }
        }
        mFrameLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (WebParentLayout.this.getWebView() != null) {
                    mFrameLayout.setClickable(false);
                    WebParentLayout.this.getWebView().reload();
                }
            }
        });
    }

    void hideErrorLayout() {
        View mView = null;
        mView = this.findViewById(R.id.agentweb_mainframe_error_container_id);
        if (mView != null) {
            mView.setVisibility(8);
        }
    }

    void setErrorView(@NonNull View errorView) {
        this.mErrorView = errorView;
    }

    void setErrorLayoutRes(@LayoutRes int resLayout, @IdRes int id2) {
        this.mClickId = id2;
        if (this.mClickId <= 0) {
            this.mClickId = -1;
        }
        this.mErrorLayoutRes = resLayout;
        if (this.mErrorLayoutRes <= 0) {
            this.mErrorLayoutRes = R.layout.agentweb_error_page;
        }
    }

    @Override
    public AbsAgentWebUIController provide() {
        return this.mAgentWebUIController;
    }

    void bindWebView(WebView view) {
        if (this.mWebView == null) {
            this.mWebView = view;
        }
    }

    WebView getWebView() {
        return this.mWebView;
    }
}

