/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.os.Handler;
import android.os.Looper;
import android.webkit.WebView;
import com.gymchina.android.agentweb.AgentWebUtils;
import com.gymchina.android.agentweb.HttpHeaders;
import com.gymchina.android.agentweb.IUrlLoader;
import java.util.Map;

public class UrlLoaderImpl
implements IUrlLoader {
    private Handler mHandler = null;
    private WebView mWebView;
    private HttpHeaders mHttpHeaders;

    UrlLoaderImpl(WebView webView, HttpHeaders httpHeaders) {
        this.mWebView = webView;
        if (this.mWebView == null) {
            new NullPointerException("webview cannot be null .");
        }
        this.mHttpHeaders = httpHeaders;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    private void safeLoadUrl(final String url) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                UrlLoaderImpl.this.loadUrl(url);
            }
        });
    }

    private void safeReload() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                UrlLoaderImpl.this.reload();
            }
        });
    }

    @Override
    public void loadUrl(String url) {
        this.loadUrl(url, null);
    }

    @Override
    public void loadUrl(final String url, final Map<String, String> headers) {
        if (!AgentWebUtils.isUIThread()) {
            AgentWebUtils.runInUiThread(new Runnable(){

                @Override
                public void run() {
                    UrlLoaderImpl.this.loadUrl(url, headers);
                }
            });
        }
        if (headers == null || headers.isEmpty()) {
            this.mWebView.loadUrl(url);
        } else {
            this.mWebView.loadUrl(url, headers);
        }
    }

    @Override
    public void reload() {
        if (!AgentWebUtils.isUIThread()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    UrlLoaderImpl.this.reload();
                }
            });
            return;
        }
        this.mWebView.reload();
    }

    @Override
    public void loadData(final String data, final String mimeType, final String encoding) {
        if (!AgentWebUtils.isUIThread()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    UrlLoaderImpl.this.loadData(data, mimeType, encoding);
                }
            });
            return;
        }
        this.mWebView.loadData(data, mimeType, encoding);
    }

    @Override
    public void stopLoading() {
        if (!AgentWebUtils.isUIThread()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    UrlLoaderImpl.this.stopLoading();
                }
            });
            return;
        }
        this.mWebView.stopLoading();
    }

    @Override
    public void loadDataWithBaseURL(final String baseUrl, final String data, final String mimeType, final String encoding, final String historyUrl) {
        if (!AgentWebUtils.isUIThread()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    UrlLoaderImpl.this.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
                }
            });
            return;
        }
        this.mWebView.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    @Override
    public void postUrl(final String url, final byte[] postData) {
        if (!AgentWebUtils.isUIThread()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    UrlLoaderImpl.this.postUrl(url, postData);
                }
            });
            return;
        }
        this.mWebView.postUrl(url, postData);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.mHttpHeaders == null ? (this.mHttpHeaders = HttpHeaders.create()) : this.mHttpHeaders;
    }
}

