/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.StatFs;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.FileProvider;
import android.support.v4.os.EnvironmentCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.Toast;
import com.gymchina.android.agentweb.AbsAgentWebUIController;
import com.gymchina.android.agentweb.AgentWebConfig;
import com.gymchina.android.agentweb.LogUtils;
import com.gymchina.android.agentweb.PermissionInterceptor;
import com.gymchina.android.agentweb.R;
import com.gymchina.android.agentweb.WebParentLayout;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AgentWebUtils {
    private static final String TAG = AgentWebUtils.class.getSimpleName();
    private static Handler mHandler = null;
    private static WeakReference<Snackbar> snackbarWeakReference;
    private static Toast mToast;

    private AgentWebUtils() {
        throw new UnsupportedOperationException("u can't init me");
    }

    public static int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    static final void clearWebView(WebView m) {
        if (m == null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        m.loadUrl("about:blank");
        m.stopLoading();
        if (m.getHandler() != null) {
            m.getHandler().removeCallbacksAndMessages(null);
        }
        m.removeAllViews();
        ViewGroup mViewGroup = null;
        mViewGroup = (ViewGroup)m.getParent();
        if (mViewGroup != null) {
            mViewGroup.removeView((View)m);
        }
        m.setWebChromeClient(null);
        m.setWebViewClient(null);
        m.setTag(null);
        m.clearHistory();
        m.destroy();
        m = null;
    }

    static String getAgentWebFilePath(Context context) {
        if (!TextUtils.isEmpty((CharSequence)AgentWebConfig.AGENTWEB_FILE_PATH)) {
            return AgentWebConfig.AGENTWEB_FILE_PATH;
        }
        String dir = AgentWebUtils.getDiskExternalCacheDir(context);
        File mFile = new File(dir, "agentweb-cache");
        try {
            if (!mFile.exists()) {
                mFile.mkdirs();
            }
        }
        catch (Throwable throwable) {
            LogUtils.i(TAG, "create dir exception");
        }
        LogUtils.i(TAG, "path:" + mFile.getAbsolutePath() + "  path:" + mFile.getPath());
        AgentWebConfig.AGENTWEB_FILE_PATH = mFile.getAbsolutePath();
        return AgentWebConfig.AGENTWEB_FILE_PATH;
    }

    public static File createFileByName(Context context, String name, boolean cover) throws IOException {
        String path = AgentWebUtils.getAgentWebFilePath(context);
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File mFile = new File(path, name);
        if (mFile.exists()) {
            if (cover) {
                mFile.delete();
                mFile.createNewFile();
            }
        } else {
            mFile.createNewFile();
        }
        return mFile;
    }

    public static int checkNetworkType(Context context) {
        int netType = 0;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        switch (networkInfo.getType()) {
            case 1: 
            case 6: 
            case 9: {
                return 1;
            }
            case 0: {
                switch (networkInfo.getSubtype()) {
                    case 13: 
                    case 14: 
                    case 15: {
                        return 2;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 12: {
                        return 3;
                    }
                    case 1: 
                    case 2: {
                        return 4;
                    }
                }
                return netType;
            }
        }
        return netType;
    }

    public static long getAvailableStorage() {
        try {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().toString());
            if (Build.VERSION.SDK_INT >= 18) {
                return stat.getAvailableBlocksLong() * stat.getBlockSizeLong();
            }
            return (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        }
        catch (RuntimeException ex) {
            return 0L;
        }
    }

    static Uri getUriFromFile(Context context, File file) {
        Uri uri = null;
        uri = Build.VERSION.SDK_INT >= 24 ? AgentWebUtils.getUriFromFileForN(context, file) : Uri.fromFile((File)file);
        return uri;
    }

    static Uri getUriFromFileForN(Context context, File file) {
        Uri fileUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".AgentWebFileProvider"), (File)file);
        return fileUri;
    }

    static void setIntentDataAndType(Context context, Intent intent, String type, File file, boolean writeAble) {
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setDataAndType(AgentWebUtils.getUriFromFile(context, file), type);
            intent.addFlags(1);
            if (writeAble) {
                intent.addFlags(2);
            }
        } else {
            intent.setDataAndType(Uri.fromFile((File)file), type);
        }
    }

    static void setIntentData(Context context, Intent intent, File file, boolean writeAble) {
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setData(AgentWebUtils.getUriFromFile(context, file));
            intent.addFlags(1);
            if (writeAble) {
                intent.addFlags(2);
            }
        } else {
            intent.setData(Uri.fromFile((File)file));
        }
    }

    static String getDiskExternalCacheDir(Context context) {
        File mFile = context.getExternalCacheDir();
        if ("mounted".equals(EnvironmentCompat.getStorageState((File)mFile))) {
            return mFile.getAbsolutePath();
        }
        return null;
    }

    static void grantPermissions(Context context, Intent intent, Uri uri, boolean writeAble) {
        int flag = 1;
        if (writeAble) {
            flag |= 2;
        }
        intent.addFlags(flag);
        List resInfoList = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, uri, flag);
        }
    }

    private static String getMIMEType(File f) {
        String type = "";
        String fName = f.getName();
        String end = fName.substring(fName.lastIndexOf(".") + 1, fName.length()).toLowerCase();
        type = end.equals("pdf") ? "application/pdf" : (end.equals("m4a") || end.equals("mp3") || end.equals("mid") || end.equals("xmf") || end.equals("ogg") || end.equals("wav") ? "audio/*" : (end.equals("3gp") || end.equals("mp4") ? "video/*" : (end.equals("jpg") || end.equals("gif") || end.equals("png") || end.equals("jpeg") || end.equals("bmp") ? "image/*" : (end.equals("apk") ? "application/vnd.android.package-archive" : (end.equals("pptx") || end.equals("ppt") ? "application/vnd.ms-powerpoint" : (end.equals("docx") || end.equals("doc") ? "application/vnd.ms-word" : (end.equals("xlsx") || end.equals("xls") ? "application/vnd.ms-excel" : "*/*")))))));
        return type;
    }

    static void show(View parent, CharSequence text, int duration, @ColorInt int textColor, @ColorInt int bgColor, CharSequence actionText, @ColorInt int actionTextColor, View.OnClickListener listener) {
        SpannableString spannableString = new SpannableString(text);
        ForegroundColorSpan colorSpan = new ForegroundColorSpan(textColor);
        spannableString.setSpan((Object)colorSpan, 0, spannableString.length(), 33);
        snackbarWeakReference = new WeakReference<Snackbar>(Snackbar.make((View)parent, (CharSequence)spannableString, (int)duration));
        Snackbar snackbar = (Snackbar)snackbarWeakReference.get();
        View view = snackbar.getView();
        view.setBackgroundColor(bgColor);
        if (actionText != null && actionText.length() > 0 && listener != null) {
            snackbar.setActionTextColor(actionTextColor);
            snackbar.setAction(actionText, listener);
        }
        snackbar.show();
    }

    static void dismiss() {
        if (snackbarWeakReference != null && snackbarWeakReference.get() != null) {
            ((Snackbar)snackbarWeakReference.get()).dismiss();
            snackbarWeakReference = null;
        }
    }

    public static boolean checkWifi(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean checkNetwork(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    static boolean isOverriedMethod(Object currentObject, String methodName, String method, Class ... clazzs) {
        boolean tag;
        block3: {
            LogUtils.i(TAG, "  methodName:" + methodName + "   method:" + method);
            tag = false;
            if (currentObject == null) {
                return tag;
            }
            try {
                Class<?> clazz = currentObject.getClass();
                Method mMethod = clazz.getMethod(methodName, clazzs);
                String gStr = mMethod.toGenericString();
                tag = !gStr.contains(method);
            }
            catch (Exception igonre) {
                if (!LogUtils.isDebug()) break block3;
                igonre.printStackTrace();
            }
        }
        LogUtils.i(TAG, "isOverriedMethod:" + tag);
        return tag;
    }

    static Method isExistMethod(Object o, String methodName, Class ... clazzs) {
        if (null == o) {
            return null;
        }
        try {
            Class<?> clazz = o.getClass();
            Method mMethod = clazz.getDeclaredMethod(methodName, clazzs);
            mMethod.setAccessible(true);
            return mMethod;
        }
        catch (Throwable ignore) {
            if (LogUtils.isDebug()) {
                ignore.printStackTrace();
            }
            return null;
        }
    }

    static void clearAgentWebCache(Context context) {
        block2: {
            try {
                AgentWebUtils.clearCacheFolder(new File(AgentWebUtils.getAgentWebFilePath(context)), 0);
            }
            catch (Throwable throwable) {
                if (!LogUtils.isDebug()) break block2;
                throwable.printStackTrace();
            }
        }
    }

    static void clearWebViewAllCache(Context context, WebView webView) {
        block2: {
            try {
                AgentWebConfig.removeAllCookies(null);
                webView.getSettings().setCacheMode(2);
                context.deleteDatabase("webviewCache.db");
                context.deleteDatabase("webview.db");
                webView.clearCache(true);
                webView.clearHistory();
                webView.clearFormData();
                AgentWebUtils.clearCacheFolder(new File(AgentWebConfig.getCachePath(context)), 0);
            }
            catch (Exception ignore) {
                if (!AgentWebConfig.DEBUG) break block2;
                ignore.printStackTrace();
            }
        }
    }

    static void clearWebViewAllCache(Context context) {
        try {
            AgentWebUtils.clearWebViewAllCache(context, new WebView(context.getApplicationContext()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static int clearCacheFolder(File dir, int numDays) {
        int deletedFiles = 0;
        if (dir != null) {
            Log.i((String)"Info", (String)("dir:" + dir.getAbsolutePath()));
        }
        if (dir != null && dir.isDirectory()) {
            try {
                for (File child : dir.listFiles()) {
                    if (child.isDirectory()) {
                        deletedFiles += AgentWebUtils.clearCacheFolder(child, numDays);
                    }
                    if (child.lastModified() >= new Date().getTime() - (long)numDays * 86400000L) continue;
                    Log.i((String)TAG, (String)("file name:" + child.getName()));
                    if (!child.delete()) continue;
                    ++deletedFiles;
                }
            }
            catch (Exception e) {
                Log.e((String)"Info", (String)String.format("Failed to clean the cache, result %s", e.getMessage()));
            }
        }
        return deletedFiles;
    }

    static void clearCache(Context context, int numDays) {
        Log.i((String)"Info", (String)String.format("Starting cache prune, deleting files older than %d days", numDays));
        int numDeletedFiles = AgentWebUtils.clearCacheFolder(context.getCacheDir(), numDays);
        Log.i((String)"Info", (String)String.format("Cache pruning completed, %d files deleted", numDeletedFiles));
    }

    public static String[] uriToPath(Activity activity, Uri[] uris) {
        if (activity == null || uris == null || uris.length == 0) {
            return null;
        }
        try {
            String[] paths = new String[uris.length];
            int i = 0;
            for (Uri mUri : uris) {
                paths[i++] = Build.VERSION.SDK_INT > 18 ? AgentWebUtils.getFileAbsolutePath(activity, mUri) : AgentWebUtils.getRealPathBelowVersion((Context)activity, mUri);
            }
            return paths;
        }
        catch (Throwable throwable) {
            if (LogUtils.isDebug()) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    private static String getRealPathBelowVersion(Context context, Uri uri) {
        String filePath = null;
        LogUtils.i(TAG, "method -> getRealPathBelowVersion " + uri + "   path:" + uri.getPath() + "    getAuthority:" + uri.getAuthority());
        String[] projection = new String[]{"_data"};
        CursorLoader loader = new CursorLoader(context, uri, projection, null, null, null);
        Cursor cursor = loader.loadInBackground();
        if (cursor != null) {
            cursor.moveToFirst();
            filePath = cursor.getString(cursor.getColumnIndex(projection[0]));
            cursor.close();
        }
        if (filePath == null) {
            filePath = uri.getPath();
        }
        return filePath;
    }

    static File createImageFile(Context context) {
        File mFile = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String imageName = String.format("aw_%s.jpg", timeStamp);
            mFile = AgentWebUtils.createFileByName(context, imageName, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mFile;
    }

    public static void closeIO(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=19)
    static String getFileAbsolutePath(Activity context, Uri fileUri) {
        if (context == null || fileUri == null) {
            return null;
        }
        LogUtils.i(TAG, "getAuthority:" + fileUri.getAuthority() + "  getHost:" + fileUri.getHost() + "   getPath:" + fileUri.getPath() + "  getScheme:" + fileUri.getScheme() + "  query:" + fileUri.getQuery());
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)fileUri)) {
            if (AgentWebUtils.isExternalStorageDocument(fileUri)) {
                String docId = DocumentsContract.getDocumentId((Uri)fileUri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (AgentWebUtils.isDownloadsDocument(fileUri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)fileUri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return AgentWebUtils.getDataColumn((Context)context, contentUri, null, null);
                }
                if (AgentWebUtils.isMediaDocument(fileUri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)fileUri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return AgentWebUtils.getDataColumn((Context)context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (fileUri.getAuthority().equalsIgnoreCase(context.getPackageName() + ".AgentWebFileProvider")) {
                String path = fileUri.getPath();
                int index = path.lastIndexOf("/");
                return AgentWebUtils.getAgentWebFilePath((Context)context) + File.separator + path.substring(index + 1, path.length());
            }
            if ("content".equalsIgnoreCase(fileUri.getScheme())) {
                if (AgentWebUtils.isGooglePhotosUri(fileUri)) {
                    return fileUri.getLastPathSegment();
                }
                return AgentWebUtils.getDataColumn((Context)context, fileUri, null, null);
            }
            if ("file".equalsIgnoreCase(fileUri.getScheme())) {
                return fileUri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String[] projection = new String[]{"_data"};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(index);
                return string2;
            }
        }
        return null;
    }

    static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    static Intent getInstallApkIntentCompat(Context context, File file) {
        Intent mIntent = new Intent().setAction("android.intent.action.VIEW");
        AgentWebUtils.setIntentDataAndType(context, mIntent, "application/vnd.android.package-archive", file, false);
        return mIntent;
    }

    public static Intent getCommonFileIntentCompat(Context context, File file) {
        Intent mIntent = new Intent().setAction("android.intent.action.VIEW");
        AgentWebUtils.setIntentDataAndType(context, mIntent, AgentWebUtils.getMIMEType(file), file, false);
        return mIntent;
    }

    static Intent getIntentCaptureCompat(Context context, File file) {
        Intent mIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri mUri = AgentWebUtils.getUriFromFile(context, file);
        mIntent.addCategory("android.intent.category.DEFAULT");
        mIntent.putExtra("output", (Parcelable)mUri);
        return mIntent;
    }

    static boolean isJson(String target) {
        if (TextUtils.isEmpty((CharSequence)target)) {
            return false;
        }
        boolean tag = false;
        try {
            if (target.startsWith("[")) {
                new JSONArray(target);
            } else {
                new JSONObject(target);
            }
            tag = true;
        }
        catch (JSONException ignore) {
            tag = false;
        }
        return tag;
    }

    public static boolean isUIThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    static boolean isEmptyCollection(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    static boolean isEmptyMap(Map map) {
        return map == null || map.isEmpty();
    }

    static void toastShowShort(Context context, String msg) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)msg, (int)0);
        } else {
            mToast.setText((CharSequence)msg);
        }
        mToast.show();
    }

    @Deprecated
    static void getUIControllerAndShowMessage(Activity activity, String message, String from) {
        if (activity == null || activity.isFinishing()) {
            return;
        }
        WebParentLayout mWebParentLayout = (WebParentLayout)activity.findViewById(R.id.agentweb_web_parent_layout_id);
        AbsAgentWebUIController mAgentWebUIController = mWebParentLayout.provide();
        if (mAgentWebUIController != null) {
            mAgentWebUIController.onShowMessage(message, from);
        }
    }

    public static boolean hasPermission(@NonNull Context context, String ... permissions) {
        return AgentWebUtils.hasPermission(context, Arrays.asList(permissions));
    }

    public static boolean hasPermission(@NonNull Context context, @NonNull List<String> permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission2 : permissions) {
            int result = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
            if (result == -1) {
                return false;
            }
            String op = AppOpsManagerCompat.permissionToOp((String)permission2);
            if (TextUtils.isEmpty((CharSequence)op) || (result = AppOpsManagerCompat.noteProxyOp((Context)context, (String)op, (String)context.getPackageName())) == 0) continue;
            return false;
        }
        return true;
    }

    public static List<String> getDeniedPermissions(Activity activity, String[] permissions) {
        if (permissions == null || permissions.length == 0) {
            return null;
        }
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (AgentWebUtils.hasPermission((Context)activity, permissions[i])) continue;
            deniedPermissions.add(permissions[i]);
        }
        return deniedPermissions;
    }

    public static AbsAgentWebUIController getAgentWebUIControllerByWebView(WebView webView) {
        WebParentLayout mWebParentLayout = AgentWebUtils.getWebParentLayoutByWebView(webView);
        return mWebParentLayout.provide();
    }

    public static String getApplicationName(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }

    static WebParentLayout getWebParentLayoutByWebView(WebView webView) {
        ViewGroup mViewGroup = null;
        if (!(webView.getParent() instanceof ViewGroup)) {
            throw new IllegalStateException("please check webcreator's create method was be called ?");
        }
        mViewGroup = (ViewGroup)webView.getParent();
        while (mViewGroup != null) {
            LogUtils.i(TAG, "ViewGroup:" + mViewGroup);
            if (mViewGroup.getId() == R.id.agentweb_web_parent_layout_id) {
                WebParentLayout mWebParentLayout = (WebParentLayout)mViewGroup;
                LogUtils.i(TAG, "found WebParentLayout");
                return mWebParentLayout;
            }
            ViewParent mViewParent = mViewGroup.getParent();
            if (mViewParent instanceof ViewGroup) {
                mViewGroup = (ViewGroup)mViewParent;
                continue;
            }
            mViewGroup = null;
        }
        throw new IllegalStateException("please check webcreator's create method was be called ?");
    }

    public static void runInUiThread(Runnable runnable) {
        if (mHandler == null) {
            mHandler = new Handler(Looper.getMainLooper());
        }
        mHandler.post(runnable);
    }

    static boolean showFileChooserCompat(Activity activity, WebView webView, ValueCallback<Uri[]> valueCallbacks, WebChromeClient.FileChooserParams fileChooserParams, PermissionInterceptor permissionInterceptor, ValueCallback valueCallback, String mimeType, Handler.Callback jsChannelCallback) {
        block9: {
            try {
                Class<?> clz = Class.forName("com.gymchina.android.webview.agentweb.filechooser.FileChooser");
                Object mFileChooser$Builder = clz.getDeclaredMethod("newBuilder", Activity.class, WebView.class).invoke(null, activity, webView);
                clz = mFileChooser$Builder.getClass();
                Method mMethod = null;
                if (valueCallbacks != null) {
                    mMethod = clz.getDeclaredMethod("setUriValueCallbacks", ValueCallback.class);
                    mMethod.setAccessible(true);
                    mMethod.invoke(mFileChooser$Builder, valueCallbacks);
                }
                if (fileChooserParams != null) {
                    mMethod = clz.getDeclaredMethod("setFileChooserParams", WebChromeClient.FileChooserParams.class);
                    mMethod.setAccessible(true);
                    mMethod.invoke(mFileChooser$Builder, fileChooserParams);
                }
                if (valueCallback != null) {
                    mMethod = clz.getDeclaredMethod("setUriValueCallback", ValueCallback.class);
                    mMethod.setAccessible(true);
                    mMethod.invoke(mFileChooser$Builder, valueCallback);
                }
                if (!TextUtils.isEmpty((CharSequence)mimeType)) {
                    mMethod = clz.getDeclaredMethod("setAcceptType", String.class);
                    mMethod.setAccessible(true);
                    mMethod.invoke(mFileChooser$Builder, mimeType);
                }
                if (jsChannelCallback != null) {
                    mMethod = clz.getDeclaredMethod("setJsChannelCallback", Handler.Callback.class);
                    mMethod.setAccessible(true);
                    mMethod.invoke(mFileChooser$Builder, jsChannelCallback);
                }
                mMethod = clz.getDeclaredMethod("setPermissionInterceptor", PermissionInterceptor.class);
                mMethod.setAccessible(true);
                mMethod.invoke(mFileChooser$Builder, permissionInterceptor);
                mMethod = clz.getDeclaredMethod("build", new Class[0]);
                mMethod.setAccessible(true);
                Object mFileChooser = mMethod.invoke(mFileChooser$Builder, new Object[0]);
                mMethod = mFileChooser.getClass().getDeclaredMethod("openFileChooser", new Class[0]);
                mMethod.setAccessible(true);
                mMethod.invoke(mFileChooser, new Object[0]);
            }
            catch (Throwable throwable) {
                if (LogUtils.isDebug()) {
                    throwable.printStackTrace();
                }
                if (valueCallbacks != null) {
                    LogUtils.i(TAG, "onReceiveValue empty");
                    return false;
                }
                if (valueCallback == null) break block9;
                valueCallback.onReceiveValue(null);
            }
        }
        return true;
    }

    public static String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            if (LogUtils.isDebug()) {
                e.printStackTrace();
            }
            return "";
        }
    }

    static {
        mToast = null;
    }
}

