/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.gymchina.android.agentweb.AbsAgentWebSettings;
import com.gymchina.android.agentweb.AbsAgentWebUIController;
import com.gymchina.android.agentweb.AgentWebConfig;
import com.gymchina.android.agentweb.AgentWebJsInterfaceCompat;
import com.gymchina.android.agentweb.AgentWebSettingsImpl;
import com.gymchina.android.agentweb.AgentWebUIControllerImplBase;
import com.gymchina.android.agentweb.AgentWebUtils;
import com.gymchina.android.agentweb.BaseIndicatorSpec;
import com.gymchina.android.agentweb.BaseIndicatorView;
import com.gymchina.android.agentweb.DefaultChromeClient;
import com.gymchina.android.agentweb.DefaultWebClient;
import com.gymchina.android.agentweb.DefaultWebCreator;
import com.gymchina.android.agentweb.DefaultWebLifeCycleImpl;
import com.gymchina.android.agentweb.EventHandlerImpl;
import com.gymchina.android.agentweb.EventInterceptor;
import com.gymchina.android.agentweb.HookManager;
import com.gymchina.android.agentweb.HttpHeaders;
import com.gymchina.android.agentweb.IAgentWebSettings;
import com.gymchina.android.agentweb.IEventHandler;
import com.gymchina.android.agentweb.IUrlLoader;
import com.gymchina.android.agentweb.IVideo;
import com.gymchina.android.agentweb.IWebLayout;
import com.gymchina.android.agentweb.IndicatorController;
import com.gymchina.android.agentweb.IndicatorHandler;
import com.gymchina.android.agentweb.JsAccessEntrace;
import com.gymchina.android.agentweb.JsAccessEntraceImpl;
import com.gymchina.android.agentweb.JsInterfaceHolder;
import com.gymchina.android.agentweb.JsInterfaceHolderImpl;
import com.gymchina.android.agentweb.LogUtils;
import com.gymchina.android.agentweb.MiddlewareWebChromeBase;
import com.gymchina.android.agentweb.MiddlewareWebClientBase;
import com.gymchina.android.agentweb.PermissionInterceptor;
import com.gymchina.android.agentweb.UrlLoaderImpl;
import com.gymchina.android.agentweb.VideoImpl;
import com.gymchina.android.agentweb.WebCreator;
import com.gymchina.android.agentweb.WebLifeCycle;
import com.gymchina.android.agentweb.WebListenerManager;
import com.gymchina.android.agentweb.WebParentLayout;
import com.gymchina.android.agentweb.WebSecurityCheckLogic;
import com.gymchina.android.agentweb.WebSecurityController;
import com.gymchina.android.agentweb.WebSecurityControllerImpl;
import com.gymchina.android.agentweb.WebSecurityLogicImpl;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class AgentWeb {
    private static final String TAG = AgentWeb.class.getSimpleName();
    private Activity mActivity;
    private ViewGroup mViewGroup;
    private WebCreator mWebCreator;
    private IAgentWebSettings mAgentWebSettings;
    private AgentWeb mAgentWeb = null;
    private IndicatorController mIndicatorController;
    private WebChromeClient mWebChromeClient;
    private WebViewClient mWebViewClient;
    private boolean mEnableIndicator;
    private IEventHandler mIEventHandler;
    private ArrayMap<String, Object> mJavaObjects = new ArrayMap();
    private int TAG_TARGET = 0;
    private WebListenerManager mWebListenerManager;
    private WebSecurityController<WebSecurityCheckLogic> mWebSecurityController = null;
    private WebSecurityCheckLogic mWebSecurityCheckLogic = null;
    private WebChromeClient mTargetChromeClient;
    private SecurityType mSecurityType = SecurityType.DEFAULT_CHECK;
    private static final int ACTIVITY_TAG = 0;
    private static final int FRAGMENT_TAG = 1;
    private AgentWebJsInterfaceCompat mAgentWebJsInterfaceCompat = null;
    private JsAccessEntrace mJsAccessEntrace = null;
    private IUrlLoader mIUrlLoader = null;
    private WebLifeCycle mWebLifeCycle;
    private IVideo mIVideo = null;
    private boolean mWebClientHelper = true;
    private PermissionInterceptor mPermissionInterceptor;
    private boolean mIsInterceptUnkownUrl = false;
    private int mUrlHandleWays = -1;
    private MiddlewareWebClientBase mMiddleWrareWebClientBaseHeader;
    private MiddlewareWebChromeBase mMiddlewareWebChromeBaseHeader;
    private EventInterceptor mEventInterceptor;
    private JsInterfaceHolder mJsInterfaceHolder = null;

    private AgentWeb(AgentBuilder agentBuilder) {
        this.TAG_TARGET = agentBuilder.mTag;
        this.mActivity = agentBuilder.mActivity;
        this.mViewGroup = agentBuilder.mViewGroup;
        this.mIEventHandler = agentBuilder.mIEventHandler;
        this.mEnableIndicator = agentBuilder.mEnableIndicator;
        this.mWebCreator = agentBuilder.mWebCreator == null ? this.configWebCreator(agentBuilder.mBaseIndicatorView, agentBuilder.mIndex, agentBuilder.mLayoutParams, agentBuilder.mIndicatorColor, agentBuilder.mHeight, agentBuilder.mWebView, agentBuilder.mWebLayout) : agentBuilder.mWebCreator;
        this.mIndicatorController = agentBuilder.mIndicatorController;
        this.mWebChromeClient = agentBuilder.mWebChromeClient;
        this.mWebViewClient = agentBuilder.mWebViewClient;
        this.mAgentWeb = this;
        this.mAgentWebSettings = agentBuilder.mAgentWebSettings;
        if (agentBuilder.mJavaObject != null && !agentBuilder.mJavaObject.isEmpty()) {
            this.mJavaObjects.putAll((Map)agentBuilder.mJavaObject);
            LogUtils.i(TAG, "mJavaObject size:" + this.mJavaObjects.size());
        }
        this.mPermissionInterceptor = agentBuilder.mPermissionInterceptor == null ? null : new PermissionInterceptorWrapper(agentBuilder.mPermissionInterceptor);
        this.mSecurityType = agentBuilder.mSecurityType;
        this.mIUrlLoader = new UrlLoaderImpl(this.mWebCreator.create().getWebView(), agentBuilder.mHttpHeaders);
        if (this.mWebCreator.getWebParentLayout() instanceof WebParentLayout) {
            WebParentLayout mWebParentLayout = (WebParentLayout)this.mWebCreator.getWebParentLayout();
            mWebParentLayout.bindController(agentBuilder.mAgentWebUIController == null ? AgentWebUIControllerImplBase.build() : agentBuilder.mAgentWebUIController);
            mWebParentLayout.setErrorLayoutRes(agentBuilder.mErrorLayout, agentBuilder.mReloadId);
            mWebParentLayout.setErrorView(agentBuilder.mErrorView);
        }
        this.mWebLifeCycle = new DefaultWebLifeCycleImpl(this.mWebCreator.getWebView());
        this.mWebSecurityController = new WebSecurityControllerImpl(this.mWebCreator.getWebView(), this.mAgentWeb.mJavaObjects, this.mSecurityType);
        this.mWebClientHelper = agentBuilder.mWebClientHelper;
        this.mIsInterceptUnkownUrl = agentBuilder.mIsInterceptUnkownUrl;
        if (agentBuilder.mOpenOtherPage != null) {
            this.mUrlHandleWays = ((AgentBuilder)agentBuilder).mOpenOtherPage.code;
        }
        this.mMiddleWrareWebClientBaseHeader = agentBuilder.mMiddlewareWebClientBaseHeader;
        this.mMiddlewareWebChromeBaseHeader = agentBuilder.mChromeMiddleWareHeader;
        this.init();
    }

    public PermissionInterceptor getPermissionInterceptor() {
        return this.mPermissionInterceptor;
    }

    public WebLifeCycle getWebLifeCycle() {
        return this.mWebLifeCycle;
    }

    public JsAccessEntrace getJsAccessEntrace() {
        JsAccessEntrace mJsAccessEntrace = this.mJsAccessEntrace;
        if (mJsAccessEntrace == null) {
            this.mJsAccessEntrace = mJsAccessEntrace = JsAccessEntraceImpl.getInstance(this.mWebCreator.getWebView());
        }
        return mJsAccessEntrace;
    }

    public AgentWeb clearWebCache() {
        if (this.getWebCreator().getWebView() != null) {
            AgentWebUtils.clearWebViewAllCache((Context)this.mActivity, this.getWebCreator().getWebView());
        } else {
            AgentWebUtils.clearWebViewAllCache((Context)this.mActivity);
        }
        return this;
    }

    public static AgentBuilder with(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity can not be null .");
        }
        return new AgentBuilder(activity);
    }

    public static AgentBuilder with(@NonNull Fragment fragment) {
        FragmentActivity mActivity = null;
        mActivity = fragment.getActivity();
        if (mActivity == null) {
            throw new NullPointerException("activity can not be null .");
        }
        return new AgentBuilder((Activity)mActivity, fragment);
    }

    public boolean handleKeyEvent(int keyCode, KeyEvent keyEvent) {
        if (this.mIEventHandler == null) {
            this.mIEventHandler = EventHandlerImpl.getInstantce(this.mWebCreator.getWebView(), this.getInterceptor());
        }
        return this.mIEventHandler.onKeyDown(keyCode, keyEvent);
    }

    public boolean back() {
        if (this.mIEventHandler == null) {
            this.mIEventHandler = EventHandlerImpl.getInstantce(this.mWebCreator.getWebView(), this.getInterceptor());
        }
        return this.mIEventHandler.back();
    }

    public WebCreator getWebCreator() {
        return this.mWebCreator;
    }

    public IEventHandler getIEventHandler() {
        return this.mIEventHandler == null ? (this.mIEventHandler = EventHandlerImpl.getInstantce(this.mWebCreator.getWebView(), this.getInterceptor())) : this.mIEventHandler;
    }

    public IAgentWebSettings getAgentWebSettings() {
        return this.mAgentWebSettings;
    }

    public IndicatorController getIndicatorController() {
        return this.mIndicatorController;
    }

    public JsInterfaceHolder getJsInterfaceHolder() {
        return this.mJsInterfaceHolder;
    }

    public IUrlLoader getUrlLoader() {
        return this.mIUrlLoader;
    }

    public void destroy() {
        this.mWebLifeCycle.onDestroy();
    }

    private void doSafeCheck() {
        WebSecurityCheckLogic mWebSecurityCheckLogic = this.mWebSecurityCheckLogic;
        if (mWebSecurityCheckLogic == null) {
            this.mWebSecurityCheckLogic = mWebSecurityCheckLogic = WebSecurityLogicImpl.getInstance();
        }
        this.mWebSecurityController.check(mWebSecurityCheckLogic);
    }

    private void doCompat() {
        this.mAgentWebJsInterfaceCompat = new AgentWebJsInterfaceCompat(this, this.mActivity);
        this.mJavaObjects.put((Object)"agentWeb", (Object)this.mAgentWebJsInterfaceCompat);
    }

    private WebCreator configWebCreator(BaseIndicatorView progressView, int index, ViewGroup.LayoutParams lp, int indicatorColor, int height_dp, WebView webView, IWebLayout webLayout) {
        if (progressView != null && this.mEnableIndicator) {
            return new DefaultWebCreator(this.mActivity, this.mViewGroup, lp, index, progressView, webView, webLayout);
        }
        return this.mEnableIndicator ? new DefaultWebCreator(this.mActivity, this.mViewGroup, lp, index, indicatorColor, height_dp, webView, webLayout) : new DefaultWebCreator(this.mActivity, this.mViewGroup, lp, index, webView, webLayout);
    }

    private AgentWeb go(String url) {
        this.getUrlLoader().loadUrl(url);
        IndicatorController mIndicatorController = null;
        if (!TextUtils.isEmpty((CharSequence)url) && (mIndicatorController = this.getIndicatorController()) != null && mIndicatorController.offerIndicator() != null) {
            this.getIndicatorController().offerIndicator().show();
        }
        return this;
    }

    private EventInterceptor getInterceptor() {
        if (this.mEventInterceptor != null) {
            return this.mEventInterceptor;
        }
        if (this.mIVideo instanceof VideoImpl) {
            this.mEventInterceptor = (EventInterceptor)((Object)this.mIVideo);
            return this.mEventInterceptor;
        }
        return null;
    }

    private void init() {
        this.doCompat();
        this.doSafeCheck();
    }

    private IVideo getIVideo() {
        return this.mIVideo == null ? new VideoImpl(this.mActivity, this.mWebCreator.getWebView()) : this.mIVideo;
    }

    private WebViewClient getWebViewClient() {
        LogUtils.i(TAG, "getDelegate:" + (Object)((Object)this.mMiddleWrareWebClientBaseHeader));
        DefaultWebClient mDefaultWebClient = DefaultWebClient.createBuilder().setActivity(this.mActivity).setClient(this.mWebViewClient).setWebClientHelper(this.mWebClientHelper).setPermissionInterceptor(this.mPermissionInterceptor).setWebView(this.mWebCreator.getWebView()).setInterceptUnkownUrl(this.mIsInterceptUnkownUrl).setUrlHandleWays(this.mUrlHandleWays).build();
        MiddlewareWebClientBase header = this.mMiddleWrareWebClientBaseHeader;
        if (header != null) {
            MiddlewareWebClientBase tail = header;
            int count = 1;
            MiddlewareWebClientBase tmp = header;
            while (tmp.next() != null) {
                tail = tmp = tmp.next();
                ++count;
            }
            LogUtils.i(TAG, "MiddlewareWebClientBase middleware count:" + count);
            tail.setDelegate(mDefaultWebClient);
            return header;
        }
        return mDefaultWebClient;
    }

    private AgentWeb ready() {
        AgentWebConfig.initCookiesManager(this.mActivity.getApplicationContext());
        IAgentWebSettings mAgentWebSettings = this.mAgentWebSettings;
        if (mAgentWebSettings == null) {
            this.mAgentWebSettings = mAgentWebSettings = AgentWebSettingsImpl.getInstance();
        }
        if (mAgentWebSettings instanceof AbsAgentWebSettings) {
            ((AbsAgentWebSettings)mAgentWebSettings).bindAgentWeb(this);
        }
        if (this.mWebListenerManager == null && mAgentWebSettings instanceof AbsAgentWebSettings) {
            this.mWebListenerManager = (WebListenerManager)((Object)mAgentWebSettings);
        }
        mAgentWebSettings.toSetting(this.mWebCreator.getWebView());
        if (this.mJsInterfaceHolder == null) {
            this.mJsInterfaceHolder = JsInterfaceHolderImpl.getJsInterfaceHolder(this.mWebCreator.getWebView(), this.mSecurityType);
        }
        LogUtils.i(TAG, "mJavaObjects:" + this.mJavaObjects.size());
        if (this.mJavaObjects != null && !this.mJavaObjects.isEmpty()) {
            this.mJsInterfaceHolder.addJavaObjects((Map<String, Object>)this.mJavaObjects);
        }
        if (this.mWebListenerManager != null) {
            this.mWebListenerManager.setDownloader(this.mWebCreator.getWebView(), null);
            this.mWebListenerManager.setWebChromeClient(this.mWebCreator.getWebView(), this.getChromeClient());
            this.mWebListenerManager.setWebViewClient(this.mWebCreator.getWebView(), this.getWebViewClient());
        }
        return this;
    }

    private WebChromeClient getChromeClient() {
        IndicatorController mIndicatorController;
        this.mIndicatorController = mIndicatorController = this.mIndicatorController == null ? IndicatorHandler.getInstance().inJectIndicator((BaseIndicatorSpec)this.mWebCreator.offer()) : this.mIndicatorController;
        this.mIVideo = this.getIVideo();
        DefaultChromeClient mDefaultChromeClient = new DefaultChromeClient(this.mActivity, this.mIndicatorController, this.mWebChromeClient, this.mIVideo, this.mPermissionInterceptor, this.mWebCreator.getWebView());
        LogUtils.i(TAG, "WebChromeClient:" + this.mWebChromeClient);
        MiddlewareWebChromeBase header = this.mMiddlewareWebChromeBaseHeader;
        if (header != null) {
            MiddlewareWebChromeBase tail = header;
            int count = 1;
            MiddlewareWebChromeBase tmp = header;
            while (tmp.next() != null) {
                tail = tmp = tmp.next();
                ++count;
            }
            LogUtils.i(TAG, "MiddlewareWebClientBase middleware count:" + count);
            tail.setDelegate(mDefaultChromeClient);
            this.mTargetChromeClient = header;
            return this.mTargetChromeClient;
        }
        this.mTargetChromeClient = mDefaultChromeClient;
        return this.mTargetChromeClient;
    }

    private static final class PermissionInterceptorWrapper
    implements PermissionInterceptor {
        private WeakReference<PermissionInterceptor> mWeakReference;

        private PermissionInterceptorWrapper(PermissionInterceptor permissionInterceptor) {
            this.mWeakReference = new WeakReference<PermissionInterceptor>(permissionInterceptor);
        }

        @Override
        public boolean intercept(String url, String[] permissions, String a) {
            if (this.mWeakReference.get() == null) {
                return false;
            }
            return ((PermissionInterceptor)this.mWeakReference.get()).intercept(url, permissions, a);
        }
    }

    public static class CommonBuilder {
        private AgentBuilder mAgentBuilder;

        public CommonBuilder(AgentBuilder agentBuilder) {
            this.mAgentBuilder = agentBuilder;
        }

        public CommonBuilder setEventHanadler(@Nullable IEventHandler iEventHandler) {
            this.mAgentBuilder.mIEventHandler = iEventHandler;
            return this;
        }

        public CommonBuilder closeWebViewClientHelper() {
            this.mAgentBuilder.mWebClientHelper = false;
            return this;
        }

        public CommonBuilder setWebChromeClient(@Nullable WebChromeClient webChromeClient) {
            this.mAgentBuilder.mWebChromeClient = webChromeClient;
            return this;
        }

        public CommonBuilder setWebViewClient(@Nullable WebViewClient webChromeClient) {
            this.mAgentBuilder.mWebViewClient = webChromeClient;
            return this;
        }

        public CommonBuilder useMiddlewareWebClient(@NonNull MiddlewareWebClientBase middleWrareWebClientBase) {
            if (middleWrareWebClientBase == null) {
                return this;
            }
            if (this.mAgentBuilder.mMiddlewareWebClientBaseHeader == null) {
                this.mAgentBuilder.mMiddlewareWebClientBaseHeader = (this.mAgentBuilder.mMiddlewareWebClientBaseTail = middleWrareWebClientBase);
            } else {
                this.mAgentBuilder.mMiddlewareWebClientBaseTail.enq(middleWrareWebClientBase);
                this.mAgentBuilder.mMiddlewareWebClientBaseTail = middleWrareWebClientBase;
            }
            return this;
        }

        public CommonBuilder useMiddlewareWebChrome(@NonNull MiddlewareWebChromeBase middlewareWebChromeBase) {
            if (middlewareWebChromeBase == null) {
                return this;
            }
            if (this.mAgentBuilder.mChromeMiddleWareHeader == null) {
                this.mAgentBuilder.mChromeMiddleWareHeader = (this.mAgentBuilder.mChromeMiddleWareTail = middlewareWebChromeBase);
            } else {
                this.mAgentBuilder.mChromeMiddleWareTail.enq(middlewareWebChromeBase);
                this.mAgentBuilder.mChromeMiddleWareTail = middlewareWebChromeBase;
            }
            return this;
        }

        public CommonBuilder setMainFrameErrorView(@NonNull View view) {
            this.mAgentBuilder.mErrorView = view;
            return this;
        }

        public CommonBuilder setMainFrameErrorView(@LayoutRes int errorLayout, @IdRes int clickViewId) {
            this.mAgentBuilder.mErrorLayout = errorLayout;
            this.mAgentBuilder.mReloadId = clickViewId;
            return this;
        }

        public CommonBuilder setAgentWebWebSettings(@Nullable IAgentWebSettings agentWebSettings) {
            this.mAgentBuilder.mAgentWebSettings = agentWebSettings;
            return this;
        }

        public PreAgentWeb createAgentWeb() {
            return this.mAgentBuilder.buildAgentWeb();
        }

        public CommonBuilder addJavascriptInterface(@NonNull String name, @NonNull Object o) {
            this.mAgentBuilder.addJavaObject(name, o);
            return this;
        }

        public CommonBuilder setSecurityType(@NonNull SecurityType type) {
            this.mAgentBuilder.mSecurityType = type;
            return this;
        }

        public CommonBuilder setWebView(@Nullable WebView webView) {
            this.mAgentBuilder.mWebView = webView;
            return this;
        }

        public CommonBuilder setWebLayout(@Nullable IWebLayout iWebLayout) {
            this.mAgentBuilder.mWebLayout = iWebLayout;
            return this;
        }

        public CommonBuilder additionalHttpHeader(String k, String v) {
            this.mAgentBuilder.addHeader(k, v);
            return this;
        }

        public CommonBuilder setPermissionInterceptor(@Nullable PermissionInterceptor permissionInterceptor) {
            this.mAgentBuilder.mPermissionInterceptor = permissionInterceptor;
            return this;
        }

        public CommonBuilder setAgentWebUIController(@Nullable AgentWebUIControllerImplBase agentWebUIController) {
            this.mAgentBuilder.mAgentWebUIController = agentWebUIController;
            return this;
        }

        public CommonBuilder setOpenOtherPageWays(@Nullable DefaultWebClient.OpenOtherPageWays openOtherPageWays) {
            this.mAgentBuilder.mOpenOtherPage = openOtherPageWays;
            return this;
        }

        public CommonBuilder interceptUnkownUrl() {
            this.mAgentBuilder.mIsInterceptUnkownUrl = true;
            return this;
        }
    }

    public static class IndicatorBuilder {
        private AgentBuilder mAgentBuilder = null;

        public IndicatorBuilder(AgentBuilder agentBuilder) {
            this.mAgentBuilder = agentBuilder;
        }

        public CommonBuilder useDefaultIndicator(int color2) {
            this.mAgentBuilder.mEnableIndicator = true;
            this.mAgentBuilder.mIndicatorColor = color2;
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder useDefaultIndicator() {
            this.mAgentBuilder.mEnableIndicator = true;
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder closeIndicator() {
            this.mAgentBuilder.mEnableIndicator = false;
            this.mAgentBuilder.mIndicatorColor = -1;
            this.mAgentBuilder.mHeight = -1;
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder setCustomIndicator(@NonNull BaseIndicatorView v) {
            if (v != null) {
                this.mAgentBuilder.mEnableIndicator = true;
                this.mAgentBuilder.mBaseIndicatorView = v;
                this.mAgentBuilder.mIsNeedDefaultProgress = false;
            } else {
                this.mAgentBuilder.mEnableIndicator = true;
                this.mAgentBuilder.mIsNeedDefaultProgress = true;
            }
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder useDefaultIndicator(@ColorInt int color2, int height_dp) {
            this.mAgentBuilder.mIndicatorColor = color2;
            this.mAgentBuilder.mHeight = height_dp;
            return new CommonBuilder(this.mAgentBuilder);
        }
    }

    public static final class AgentBuilder {
        private Activity mActivity;
        private Fragment mFragment;
        private ViewGroup mViewGroup;
        private boolean mIsNeedDefaultProgress;
        private int mIndex = -1;
        private BaseIndicatorView mBaseIndicatorView;
        private IndicatorController mIndicatorController = null;
        private boolean mEnableIndicator = true;
        private ViewGroup.LayoutParams mLayoutParams = null;
        private WebViewClient mWebViewClient;
        private WebChromeClient mWebChromeClient;
        private int mIndicatorColor = -1;
        private IAgentWebSettings mAgentWebSettings;
        private WebCreator mWebCreator;
        private HttpHeaders mHttpHeaders = null;
        private IEventHandler mIEventHandler;
        private int mHeight = -1;
        private ArrayMap<String, Object> mJavaObject;
        private SecurityType mSecurityType = SecurityType.DEFAULT_CHECK;
        private WebView mWebView;
        private boolean mWebClientHelper = true;
        private IWebLayout mWebLayout = null;
        private PermissionInterceptor mPermissionInterceptor = null;
        private AbsAgentWebUIController mAgentWebUIController;
        private DefaultWebClient.OpenOtherPageWays mOpenOtherPage = null;
        private boolean mIsInterceptUnkownUrl = false;
        private MiddlewareWebClientBase mMiddlewareWebClientBaseHeader;
        private MiddlewareWebClientBase mMiddlewareWebClientBaseTail;
        private MiddlewareWebChromeBase mChromeMiddleWareHeader = null;
        private MiddlewareWebChromeBase mChromeMiddleWareTail = null;
        private View mErrorView;
        private int mErrorLayout;
        private int mReloadId;
        private int mTag = -1;

        public AgentBuilder(@NonNull Activity activity, @NonNull Fragment fragment) {
            this.mActivity = activity;
            this.mFragment = fragment;
            this.mTag = 1;
        }

        public AgentBuilder(@NonNull Activity activity) {
            this.mActivity = activity;
            this.mTag = 0;
        }

        public IndicatorBuilder setAgentWebParent(@NonNull ViewGroup v, @NonNull ViewGroup.LayoutParams lp) {
            this.mViewGroup = v;
            this.mLayoutParams = lp;
            return new IndicatorBuilder(this);
        }

        public IndicatorBuilder setAgentWebParent(@NonNull ViewGroup v, int index, @NonNull ViewGroup.LayoutParams lp) {
            this.mViewGroup = v;
            this.mLayoutParams = lp;
            this.mIndex = index;
            return new IndicatorBuilder(this);
        }

        private PreAgentWeb buildAgentWeb() {
            if (this.mTag == 1 && this.mViewGroup == null) {
                throw new NullPointerException("ViewGroup is null,Please check your parameters .");
            }
            return new PreAgentWeb(HookManager.hookAgentWeb(new AgentWeb(this), this));
        }

        private void addJavaObject(String key, Object o) {
            if (this.mJavaObject == null) {
                this.mJavaObject = new ArrayMap();
            }
            this.mJavaObject.put((Object)key, o);
        }

        private void addHeader(String k, String v) {
            if (this.mHttpHeaders == null) {
                this.mHttpHeaders = HttpHeaders.create();
            }
            this.mHttpHeaders.additionalHttpHeader(k, v);
        }
    }

    public static enum SecurityType {
        DEFAULT_CHECK,
        STRICT_CHECK;

    }

    public static class PreAgentWeb {
        private AgentWeb mAgentWeb;
        private boolean isReady = false;

        PreAgentWeb(AgentWeb agentWeb) {
            this.mAgentWeb = agentWeb;
        }

        public AgentWeb getAgentWeb() {
            return this.mAgentWeb;
        }

        public PreAgentWeb ready() {
            if (!this.isReady) {
                this.mAgentWeb.ready();
                this.isReady = true;
            }
            return this;
        }

        public AgentWeb go(@Nullable String url) {
            if (!this.isReady) {
                this.ready();
            }
            return this.mAgentWeb.go(url);
        }
    }
}

